/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.InvalidAuthorizationHeaderException;
import com.intellij.hub.auth.InvalidPermanentTokenException;
import com.intellij.hub.auth.InvalidTokenDataException;
import com.intellij.hub.auth.InvalidTokenScopeException;
import com.intellij.hub.auth.InvalidTokenSignatureException;
import com.intellij.hub.auth.InvalidTokenUserException;
import com.intellij.hub.auth.OAuthException;
import com.intellij.hub.auth.TokenExpiredException;
import com.intellij.hub.auth.UnknownTokenClientException;
import com.intellij.hub.auth.oauth2.error.OAuthErrorCode;
import com.intellij.hub.auth.oauth2.error.VerifyTokenErrorCode;
import com.intellij.hub.core.Error;
import java.util.Date;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\b\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/hub/auth/InvalidTokenException;", "Lcom/intellij/hub/auth/OAuthException;", "code", "Lcom/intellij/hub/auth/oauth2/error/VerifyTokenErrorCode;", "description", "", "(Lcom/intellij/hub/auth/oauth2/error/VerifyTokenErrorCode;Ljava/lang/String;)V", "cause", "", "(Lcom/intellij/hub/auth/oauth2/error/VerifyTokenErrorCode;Ljava/lang/Throwable;)V", "(Lcom/intellij/hub/auth/oauth2/error/VerifyTokenErrorCode;Ljava/lang/String;Ljava/lang/Throwable;)V", "getCode", "()Lcom/intellij/hub/auth/oauth2/error/VerifyTokenErrorCode;", "oAuthError", "Lcom/intellij/hub/core/Error;", "getOAuthError", "()Lcom/intellij/hub/core/Error;", "Companion", "com.intellij.hub.auth"})
public class InvalidTokenException
extends OAuthException {
    @NotNull
    private final VerifyTokenErrorCode code;
    private final String description;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final VerifyTokenErrorCode getCode() {
        return this.code;
    }

    @Override
    @NotNull
    public Error getOAuthError() {
        Throwable cause = this.getCause();
        String devDescription = cause != null && cause != this ? this.description + ": " + cause.getMessage() : this.description;
        return OAuthErrorCode.DefaultImpls.createError$default(this.code, this.description, devDescription, null, 4, null);
    }

    @JvmOverloads
    protected InvalidTokenException(@NotNull VerifyTokenErrorCode code, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        super(description);
        this.code = code;
        this.description = description;
    }

    public /* synthetic */ InvalidTokenException(VerifyTokenErrorCode verifyTokenErrorCode, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = verifyTokenErrorCode.getDescription();
        }
        this(verifyTokenErrorCode, string);
    }

    @JvmOverloads
    protected InvalidTokenException(@NotNull VerifyTokenErrorCode code) {
        this(code, null, 2, null);
    }

    protected InvalidTokenException(@NotNull VerifyTokenErrorCode code, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        this(code, code.getDescription(), cause);
    }

    protected InvalidTokenException(@NotNull VerifyTokenErrorCode code, @NotNull String description, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        super(description, cause);
        this.code = code;
        this.description = description;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013J#\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00132\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020\u0004J\u0012\u0010 \u001a\u00020\u00042\n\u0010!\u001a\u00060\u0006j\u0002`\u0007J\u0012\u0010\"\u001a\u00020\u00042\n\u0010!\u001a\u00060\u0006j\u0002`\u0007J\u0006\u0010#\u001a\u00020\u0004J\u0012\u0010$\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060%j\u0002`&J\u0006\u0010'\u001a\u00020\u0004J\u0006\u0010(\u001a\u00020\u0004J\u0012\u0010(\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\u0012\u0010)\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060%j\u0002`&J\u0006\u0010*\u001a\u00020\u0004J\u0006\u0010+\u001a\u00020\u0004J\u0006\u0010,\u001a\u00020\u0004J\u000e\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0013J\u000e\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0013\u00a8\u00061"}, d2={"Lcom/intellij/hub/auth/InvalidTokenException$Companion;", "", "()V", "basicAndTwoFactorAuthenticationEnabled", "Lcom/intellij/hub/auth/InvalidTokenException;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "basicAuthDisabled", "basicAuthHeaderTypeExpected", "bearerAuthHeaderTypeExpected", "expired", "checkedAt", "Ljava/util/Date;", "grantedTill", "invalidAuthHeaderType", "invalidPermanentToken", "invalidPermanentTokenName", "tokenId", "", "actualId", "invalidPermanentTokenUsername", "tokenUsername", "actualUsername", "invalidTokenScope", "requiredScope", "allowedScopes", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/hub/auth/InvalidTokenException;", "invalidTokenSignature", "malformedOAuthToken", "malformedPermanentToken", "malformedPermanentTokenName", "cause", "malformedPermanentTokenUsername", "malformedTokenData", "malformedTokenExpiration", "Ljava/lang/NumberFormatException;", "Lkotlin/NumberFormatException;", "malformedTokenScope", "malformedTokenSignature", "malformedTokenVersion", "notAcceptedEndUserAgreement", "notGuestToken", "notVerifiedEmail", "unknownClient", "id", "userWasDeleted", "userID", "com.intellij.hub.auth"})
    public static final class Companion {
        @NotNull
        public final InvalidTokenException malformedOAuthToken() {
            return new InvalidTokenDataException(VerifyTokenErrorCode.TOKEN_MALFORMED);
        }

        @NotNull
        public final InvalidTokenException malformedTokenVersion(@NotNull NumberFormatException e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new InvalidTokenDataException(VerifyTokenErrorCode.TOKEN_VERSION_MALFORMED, (Throwable)e);
        }

        @NotNull
        public final InvalidTokenException malformedTokenSignature() {
            return new InvalidTokenSignatureException(VerifyTokenErrorCode.TOKEN_SIGNATURE_MALFORMED);
        }

        @NotNull
        public final InvalidTokenException malformedTokenSignature(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new InvalidTokenSignatureException(VerifyTokenErrorCode.TOKEN_SIGNATURE_MALFORMED, (Throwable)e);
        }

        @NotNull
        public final InvalidTokenException invalidTokenSignature() {
            return new InvalidTokenSignatureException(VerifyTokenErrorCode.TOKEN_SIGNATURE_INVALID);
        }

        @NotNull
        public final InvalidTokenException malformedTokenData() {
            return new InvalidTokenDataException(VerifyTokenErrorCode.TOKEN_DATA_MALFORMED);
        }

        @NotNull
        public final InvalidTokenException malformedTokenExpiration(@NotNull NumberFormatException e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new InvalidTokenDataException(VerifyTokenErrorCode.TOKEN_EXPIRATION_MALFORMED, (Throwable)e);
        }

        @NotNull
        public final InvalidTokenException invalidTokenScope(@NotNull String requiredScope, @NotNull String[] allowedScopes) {
            Intrinsics.checkParameterIsNotNull((Object)requiredScope, (String)"requiredScope");
            Intrinsics.checkParameterIsNotNull((Object)allowedScopes, (String)"allowedScopes");
            return new InvalidTokenScopeException(VerifyTokenErrorCode.TOKEN_SCOPE_INVALID, "Token is granted for " + ArraysKt.toList((Object[])allowedScopes) + " and can't be used for " + requiredScope);
        }

        @NotNull
        public final InvalidTokenException malformedTokenScope() {
            return new InvalidTokenScopeException(VerifyTokenErrorCode.TOKEN_SCOPE_MALFORMED);
        }

        @NotNull
        public final InvalidTokenException unknownClient(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return new UnknownTokenClientException(VerifyTokenErrorCode.TOKEN_CLIENT_INVALID, "Client " + id + " is unknown", id);
        }

        @NotNull
        public final InvalidTokenException userWasDeleted(@NotNull String userID) {
            Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
            return new InvalidTokenUserException(VerifyTokenErrorCode.TOKEN_USER_DELETED, "User [" + userID + "] who owned the access token was deleted");
        }

        @NotNull
        public final InvalidTokenException notVerifiedEmail() {
            return new InvalidPermanentTokenException(VerifyTokenErrorCode.TOKEN_OWNER_EMAIL_IS_NOT_VERIFIED);
        }

        @NotNull
        public final InvalidTokenException notAcceptedEndUserAgreement() {
            return new InvalidTokenException(VerifyTokenErrorCode.TOKEN_OWNER_HAS_NOT_ACCEPTED_EUA, null, 2, null);
        }

        @NotNull
        public final InvalidTokenException basicAndTwoFactorAuthenticationEnabled(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new InvalidTokenException(VerifyTokenErrorCode.BASIC_2FA_REQUIRED, null, 2, null);
        }

        @NotNull
        public final InvalidTokenException invalidPermanentToken() {
            return new InvalidPermanentTokenException(VerifyTokenErrorCode.PERMANENT_TOKEN_INVALID);
        }

        @NotNull
        public final InvalidTokenException invalidPermanentTokenUsername(@NotNull String tokenUsername, @NotNull String actualUsername) {
            Intrinsics.checkParameterIsNotNull((Object)tokenUsername, (String)"tokenUsername");
            Intrinsics.checkParameterIsNotNull((Object)actualUsername, (String)"actualUsername");
            return new InvalidPermanentTokenException(VerifyTokenErrorCode.PERMANENT_TOKEN_USERNAME_INVALID, "Token is granted to " + actualUsername + " but used for " + tokenUsername);
        }

        @NotNull
        public final InvalidTokenException invalidPermanentTokenName(@NotNull String tokenId, @NotNull String actualId) {
            Intrinsics.checkParameterIsNotNull((Object)tokenId, (String)"tokenId");
            Intrinsics.checkParameterIsNotNull((Object)actualId, (String)"actualId");
            return new InvalidPermanentTokenException(VerifyTokenErrorCode.PERMANENT_TOKEN_ID_INVALID, "Token id is " + actualId + " but it is used with a id " + tokenId);
        }

        @NotNull
        public final InvalidTokenException malformedPermanentToken() {
            return new InvalidTokenDataException(VerifyTokenErrorCode.PERMANENT_TOKEN_MALFORMED);
        }

        @NotNull
        public final InvalidTokenException malformedPermanentTokenUsername(@NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new InvalidTokenDataException(VerifyTokenErrorCode.PERMANENT_TOKEN_USERNAME_MALFORMED, (Throwable)cause);
        }

        @NotNull
        public final InvalidTokenException malformedPermanentTokenName(@NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            return new InvalidTokenDataException(VerifyTokenErrorCode.PERMANENT_TOKEN_NAME_MALFORMED, (Throwable)cause);
        }

        @NotNull
        public final InvalidTokenException notGuestToken() {
            return new InvalidTokenDataException(VerifyTokenErrorCode.NOT_GUEST_TOKEN);
        }

        @NotNull
        public final InvalidTokenException expired(@NotNull Date checkedAt, @NotNull Date grantedTill) {
            Intrinsics.checkParameterIsNotNull((Object)checkedAt, (String)"checkedAt");
            Intrinsics.checkParameterIsNotNull((Object)grantedTill, (String)"grantedTill");
            return new TokenExpiredException(VerifyTokenErrorCode.TOKEN_EXPIRED, "Token has expired. It was granted till " + grantedTill + " and was checked at " + checkedAt, checkedAt, grantedTill);
        }

        @NotNull
        public final InvalidTokenException invalidAuthHeaderType() {
            return new InvalidAuthorizationHeaderException(VerifyTokenErrorCode.AUTH_HEADER_TYPE_UNKNOWN);
        }

        @NotNull
        public final InvalidTokenException bearerAuthHeaderTypeExpected() {
            return new InvalidAuthorizationHeaderException(VerifyTokenErrorCode.BEARER_EXPECTED);
        }

        @NotNull
        public final InvalidTokenException basicAuthHeaderTypeExpected() {
            return new InvalidAuthorizationHeaderException(VerifyTokenErrorCode.BASIC_EXPECTED);
        }

        @NotNull
        public final InvalidTokenException basicAuthDisabled() {
            return new InvalidAuthorizationHeaderException(VerifyTokenErrorCode.BASIC_DISABLED);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

