/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.oauth2.error.OAuthAuthErrorCode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/hub/auth/OAuthClientValidationException;", "Lcom/intellij/hub/auth/OAuthValidationException;", "code", "Lcom/intellij/hub/auth/oauth2/error/OAuthAuthErrorCode;", "message", "", "(Lcom/intellij/hub/auth/oauth2/error/OAuthAuthErrorCode;Ljava/lang/String;)V", "Companion", "com.intellij.hub.auth"})
public final class OAuthClientValidationException
extends OAuthValidationException {
    private static final String DOC_PREFIX = "auth";
    public static final Companion Companion = new Companion(null);

    private OAuthClientValidationException(OAuthAuthErrorCode code, String message) {
        super(code, message, DOC_PREFIX);
    }

    /* synthetic */ OAuthClientValidationException(OAuthAuthErrorCode oAuthAuthErrorCode, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(oAuthAuthErrorCode, string);
    }

    static {
        DOC_PREFIX = DOC_PREFIX;
    }

    public /* synthetic */ OAuthClientValidationException(OAuthAuthErrorCode code, String message, DefaultConstructorMarker $constructor_marker) {
        this(code, message);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u0019\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0004J\u0016\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u0006J\u0006\u0010 \u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/hub/auth/OAuthClientValidationException$Companion;", "", "()V", "DOC_PREFIX", "", "authRequestDeclined", "Lcom/intellij/hub/auth/OAuthValidationException;", "cantGiveGuestOfflineAccess", "invalidCSRFCode", "Lcom/intellij/hub/auth/OAuthClientValidationException;", "invalidParameter", "parameterName", "invalidResponseType", "responseType", "invalidScope", "message", "loginRequired", "missingParameter", "requestNotSupported", "requestURINotSupported", "serviceHasNoRedirectURI", "clientServiceName", "requestedRedirectURI", "unknownScope", "scope", "", "([Ljava/lang/String;)Lcom/intellij/hub/auth/OAuthClientValidationException;", "unknownService", "serviceId", "unregisteredRedirectURI", "userBanned", "userDistrusts", "userEmailIsNotVerified", "userHasNoLicense", "com.intellij.hub.auth"})
    public static final class Companion {
        @NotNull
        public final OAuthValidationException missingParameter(@NotNull String parameterName) {
            Intrinsics.checkParameterIsNotNull((Object)parameterName, (String)"parameterName");
            return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REQUEST, "Parameter '" + parameterName + "' is required", null);
        }

        @NotNull
        public final OAuthValidationException authRequestDeclined() {
            return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "User declined authorization request", null);
        }

        @NotNull
        public final OAuthValidationException userBanned() {
            return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "Logged in user is banned", null);
        }

        @NotNull
        public final OAuthValidationException userHasNoLicense(@NotNull String clientServiceName) {
            Intrinsics.checkParameterIsNotNull((Object)clientServiceName, (String)"clientServiceName");
            return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "Logged in user has no license for the service '" + clientServiceName + '\'', null);
        }

        @NotNull
        public final OAuthValidationException userEmailIsNotVerified() {
            return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "Email of authenticated user is not verified", null);
        }

        @NotNull
        public final OAuthValidationException userDistrusts() {
            return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "User doesn't trust application", null);
        }

        @NotNull
        public final OAuthClientValidationException invalidScope(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_SCOPE, message, null);
        }

        @NotNull
        public final OAuthClientValidationException unknownScope(@NotNull String[] scope2) {
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            return this.invalidScope("Scope " + ArraysKt.toList((Object[])scope2) + " doesn't match any Service");
        }

        @NotNull
        public final OAuthClientValidationException invalidCSRFCode() {
            return new OAuthClientValidationException(OAuthAuthErrorCode.SERVER_ERROR, "Invalid CSRF token received.", null);
        }

        @NotNull
        public final OAuthValidationException cantGiveGuestOfflineAccess() {
            return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REQUEST, "Unable request offline access for Guest", null);
        }

        @NotNull
        public final OAuthValidationException invalidResponseType(@NotNull String responseType) {
            Intrinsics.checkParameterIsNotNull((Object)responseType, (String)"responseType");
            return new OAuthClientValidationException(OAuthAuthErrorCode.UNSUPPORTED_RESPONSE_TYPE, "Value of authentication parameter response_type '" + responseType + "' is unsupported", null);
        }

        @NotNull
        public final OAuthValidationException invalidParameter(@NotNull String parameterName) {
            Intrinsics.checkParameterIsNotNull((Object)parameterName, (String)"parameterName");
            return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REQUEST, "Parameter '" + parameterName + "' is invalid", null);
        }

        @NotNull
        public final OAuthClientValidationException unknownService(@NotNull String serviceId) {
            Intrinsics.checkParameterIsNotNull((Object)serviceId, (String)"serviceId");
            return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REQUEST, "Service with id \"" + serviceId + "\" was not found", null);
        }

        @NotNull
        public final OAuthValidationException serviceHasNoRedirectURI(@NotNull String clientServiceName, @NotNull String requestedRedirectURI) {
            Intrinsics.checkParameterIsNotNull((Object)clientServiceName, (String)"clientServiceName");
            Intrinsics.checkParameterIsNotNull((Object)requestedRedirectURI, (String)"requestedRedirectURI");
            return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REDIRECT_URI, "Unregistered Redirect URI. Client service '" + clientServiceName + "' is not authorized to request an authorization entity using this method because the service has no registered 'Redirect URIs'. If you have Hub administrator permissions and the URI " + requestedRedirectURI + " does belong to '" + clientServiceName + "', please add this URI to the list of 'Redirect URIs' in the service settings in Hub.", null);
        }

        @NotNull
        public final OAuthValidationException unregisteredRedirectURI(@NotNull String clientServiceName, @NotNull String requestedRedirectURI) {
            Intrinsics.checkParameterIsNotNull((Object)clientServiceName, (String)"clientServiceName");
            Intrinsics.checkParameterIsNotNull((Object)requestedRedirectURI, (String)"requestedRedirectURI");
            return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REDIRECT_URI, "Unregistered Redirect URI. Client service '" + clientServiceName + "' requests authorization entity for the URI which is not registered in Hub: " + requestedRedirectURI + ". If you have Hub administrator permissions and the suspicious URI does belong to '" + clientServiceName + "', please add this URI to the list of 'Redirect URIs' in the service settings in Hub", null);
        }

        @NotNull
        public final OAuthValidationException loginRequired() {
            return new OAuthClientValidationException(OAuthAuthErrorCode.LOGIN_REQUIRED, "The user is required to be logged in", null);
        }

        @NotNull
        public final OAuthValidationException requestNotSupported() {
            return new OAuthClientValidationException(OAuthAuthErrorCode.REQUEST_NOT_SUPPORTED, "The request parameter not supported", null);
        }

        @NotNull
        public final OAuthValidationException requestURINotSupported() {
            return new OAuthClientValidationException(OAuthAuthErrorCode.REQUEST_URI_NOT_SUPPORTED, "The request_uri parameter not supported", null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

