/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.basic;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.InvalidTokenException;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/hub/auth/basic/BasicAuthToken;", "Lcom/intellij/hub/auth/AuthToken;", "username", "", "password", "(Ljava/lang/String;Ljava/lang/String;)V", "getPassword", "()Ljava/lang/String;", "type", "getType", "getUsername", "component1", "component2", "copy", "encode", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "com.intellij.hub.auth"})
public final class BasicAuthToken
implements AuthToken {
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @NotNull
    private static final String BASIC_TYPE = "Basic";
    @NotNull
    private static final String BASIC_PREFIX = "Basic ";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String encode() {
        String string = this.username + ':' + this.password;
        Charset charset = Charsets.UTF_8;
        Base64.Encoder encoder = Base64.getEncoder();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        String string3 = encoder.encodeToString(byArray2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.getEncoder().enco\u2026yteArray(Charsets.UTF_8))");
        return string3;
    }

    @Override
    @NotNull
    public String getType() {
        return BASIC_TYPE;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    public BasicAuthToken(@NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.username = username;
        this.password = password;
    }

    static {
        BASIC_TYPE = BASIC_TYPE;
        BASIC_PREFIX = BASIC_TYPE + ' ';
    }

    @NotNull
    public final String component1() {
        return this.username;
    }

    @NotNull
    public final String component2() {
        return this.password;
    }

    @NotNull
    public final BasicAuthToken copy(@NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        return new BasicAuthToken(username, password);
    }

    public static /* synthetic */ BasicAuthToken copy$default(BasicAuthToken basicAuthToken, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = basicAuthToken.username;
        }
        if ((n & 2) != 0) {
            string2 = basicAuthToken.password;
        }
        return basicAuthToken.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "BasicAuthToken(username=" + this.username + ", password=" + this.password + ")";
    }

    public int hashCode() {
        String string = this.username;
        String string2 = this.password;
        return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BasicAuthToken)) break block3;
                BasicAuthToken basicAuthToken = (BasicAuthToken)object;
                if (!Intrinsics.areEqual((Object)this.username, (Object)basicAuthToken.username) || !Intrinsics.areEqual((Object)this.password, (Object)basicAuthToken.password)) break block3;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static final String getBASIC_TYPE() {
        Companion companion = Companion;
        return BASIC_TYPE;
    }

    @NotNull
    public static final String getBASIC_PREFIX() {
        Companion companion = Companion;
        return BASIC_PREFIX;
    }

    @JvmStatic
    @NotNull
    public static final BasicAuthToken decode(@NotNull String token) throws InvalidTokenException {
        return Companion.decode(token);
    }

    @JvmStatic
    @NotNull
    public static final BasicAuthToken decodeHeader(@NotNull String header2) throws InvalidTokenException {
        return Companion.decodeHeader(header2);
    }

    @JvmStatic
    @NotNull
    public static final String encodeHeader(@NotNull BasicAuthToken token) {
        return Companion.encodeHeader(token);
    }

    @JvmStatic
    public static final boolean isBasic(@Nullable String header2) {
        return Companion.isBasic(header2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/hub/auth/basic/BasicAuthToken$Companion;", "", "()V", "BASIC_PREFIX", "", "BASIC_PREFIX$annotations", "getBASIC_PREFIX", "()Ljava/lang/String;", "BASIC_TYPE", "BASIC_TYPE$annotations", "getBASIC_TYPE", "decode", "Lcom/intellij/hub/auth/basic/BasicAuthToken;", "token", "decodeHeader", "header", "encodeHeader", "isBasic", "", "com.intellij.hub.auth"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void BASIC_TYPE$annotations() {
        }

        @NotNull
        public final String getBASIC_TYPE() {
            return BASIC_TYPE;
        }

        @JvmStatic
        public static /* synthetic */ void BASIC_PREFIX$annotations() {
        }

        @NotNull
        public final String getBASIC_PREFIX() {
            return BASIC_PREFIX;
        }

        @JvmStatic
        @NotNull
        public final BasicAuthToken decode(@NotNull String token) throws InvalidTokenException {
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            byte[] byArray = Base64.getDecoder().decode(token);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(token)");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            boolean bl2 = false;
            String decodedB64Token = new String(byArray2, charset);
            String username = StringsKt.substringBefore$default((String)decodedB64Token, (char)':', null, (int)2, null);
            String password = StringsKt.substringAfter((String)decodedB64Token, (char)':', (String)"");
            return new BasicAuthToken(username, password);
        }

        @JvmStatic
        @NotNull
        public final BasicAuthToken decodeHeader(@NotNull String header2) throws InvalidTokenException {
            Intrinsics.checkParameterIsNotNull((Object)header2, (String)"header");
            if (!this.isBasic(header2)) {
                throw (Throwable)InvalidTokenException.Companion.basicAuthHeaderTypeExpected();
            }
            String string = header2;
            int n = this.getBASIC_PREFIX().length();
            Companion companion = Companion;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String string3 = string2;
            return companion.decode(string3);
        }

        @JvmStatic
        @NotNull
        public final String encodeHeader(@NotNull BasicAuthToken token) {
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            return this.getBASIC_PREFIX() + token.encode();
        }

        @JvmStatic
        public final boolean isBasic(@Nullable String header2) {
            return header2 != null && StringsKt.startsWith((String)header2, (String)this.getBASIC_PREFIX(), (boolean)true);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

