/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.provider.source;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/hub/auth/oauth2/provider/source/KeyAndVersion;", "", "key", "Ljava/security/interfaces/DSAPublicKey;", "version", "", "(Ljava/security/interfaces/DSAPublicKey;I)V", "getKey", "()Ljava/security/interfaces/DSAPublicKey;", "getVersion", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "com.intellij.hub.auth"})
public final class KeyAndVersion {
    @NotNull
    private final DSAPublicKey key;
    private final int version;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final DSAPublicKey getKey() {
        return this.key;
    }

    public final int getVersion() {
        return this.version;
    }

    public KeyAndVersion(@NotNull DSAPublicKey key, int version) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.key = key;
        this.version = version;
    }

    @NotNull
    public final DSAPublicKey component1() {
        return this.key;
    }

    public final int component2() {
        return this.version;
    }

    @NotNull
    public final KeyAndVersion copy(@NotNull DSAPublicKey key, int version) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return new KeyAndVersion(key, version);
    }

    public static /* synthetic */ KeyAndVersion copy$default(KeyAndVersion keyAndVersion, DSAPublicKey dSAPublicKey, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            dSAPublicKey = keyAndVersion.key;
        }
        if ((n2 & 2) != 0) {
            n = keyAndVersion.version;
        }
        return keyAndVersion.copy(dSAPublicKey, n);
    }

    @NotNull
    public String toString() {
        return "KeyAndVersion(key=" + this.key + ", version=" + this.version + ")";
    }

    public int hashCode() {
        DSAPublicKey dSAPublicKey = this.key;
        return (dSAPublicKey != null ? dSAPublicKey.hashCode() : 0) * 31 + Integer.hashCode(this.version);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof KeyAndVersion)) break block3;
                KeyAndVersion keyAndVersion = (KeyAndVersion)object;
                if (!Intrinsics.areEqual((Object)this.key, (Object)keyAndVersion.key) || !(this.version == keyAndVersion.version)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final KeyAndVersion parse(@NotNull String string) {
        return Companion.parse(string);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/hub/auth/oauth2/provider/source/KeyAndVersion$Companion;", "", "()V", "parse", "Lcom/intellij/hub/auth/oauth2/provider/source/KeyAndVersion;", "string", "", "com.intellij.hub.auth"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final KeyAndVersion parse(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            String version = StringsKt.substringBefore$default((String)string, (char)'.', null, (int)2, null);
            String key = StringsKt.substringAfter((String)string, (char)'.', (String)"");
            try {
                int n;
                KeyFactory kf = KeyFactory.getInstance("DSA");
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(key));
                PublicKey publicKey = kf.generatePublic(keySpec);
                if (publicKey == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.DSAPublicKey");
                }
                String string2 = version;
                DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
                boolean bl = false;
                int n2 = n = Integer.parseInt(string2);
                DSAPublicKey dSAPublicKey2 = dSAPublicKey;
                return new KeyAndVersion(dSAPublicKey2, n2);
            }
            catch (InvalidKeySpecException e) {
                throw (Throwable)new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw (Throwable)new RuntimeException(e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

