/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.api.event;

import java.util.Calendar;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.event.Change;

public interface Event
extends IdItem {
    public String getTargetId();

    public String getTargetType();

    public String getTargetPresentation();

    public Iterable<? extends Change> getChanges();

    public String getType();

    public Calendar getTimestamp();

    public Calendar getEraseTimestamp();

    public String getAuthor();

    public String getAuthorPresentation();

    public String getAuthorType();

    public static enum Type {
        CREATE("Create"),
        REMOVE("Remove"),
        UPDATE("Update");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public static Type fromString(String type) {
            if (type == null || type.length() == 0) {
                return null;
            }
            for (Type t : Type.values()) {
                if (!type.toLowerCase().equals(t.getName().toLowerCase())) continue;
                return t;
            }
            return null;
        }
    }
}

