/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.api.settings;

import java.util.Calendar;
import jetbrains.jetpass.api.settings.Settings;
import org.jetbrains.annotations.Nullable;

public interface BackupSettings
extends Settings {
    @Nullable
    public String getNamePrefix();

    @Nullable
    public String getBackupFolder();

    @Nullable
    public String getResolvedBackupFolder();

    @Nullable
    public String getArchiveType();

    @Nullable
    public String getCronExpression();

    public Integer getCountToKeep();

    @Nullable
    public Status getStatus();

    public Boolean isDatabaseReadonly();

    public static enum ArchiveType {
        ZIP("zip"),
        TAR_GZ("tar.gz");

        private String typeName;

        private ArchiveType(String typeName) {
            this.typeName = typeName;
        }

        public String getName() {
            return this.typeName;
        }

        public static boolean isZipArchive(String type) {
            ArchiveType t = ArchiveType.fromName(type);
            return t != null && ZIP == t;
        }

        public static ArchiveType getType(String type, ArchiveType defaultType) {
            ArchiveType t = ArchiveType.fromName(type);
            return t == null ? defaultType : t;
        }

        public static ArchiveType fromName(String name) {
            if (name == null) {
                return null;
            }
            for (ArchiveType t : ArchiveType.values()) {
                if (!t.getName().toLowerCase().equals(name.toLowerCase())) continue;
                return t;
            }
            return null;
        }

        public static ArchiveType getType(String type) {
            return ArchiveType.getType(type, TAR_GZ);
        }
    }

    public static interface Data {
        @Nullable
        public String getName();

        @Nullable
        public Calendar getTimestamp();
    }

    public static interface Status {
        @Nullable
        public Boolean isInProgress();

        @Nullable
        public Iterable<? extends Data> getSavedData();
    }
}

