/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.api.settings;

import java.util.Properties;
import jetbrains.jetpass.api.settings.Settings;
import jetbrains.jetpass.api.ssl.SecuredProvider;

public interface SMTPSettings
extends Settings,
SecuredProvider {
    public Boolean isEnabled();

    public String getHost();

    public Integer getPort();

    public String getProtocol();

    public String getFrom();

    public String getEnvelopeFrom();

    public String getLogin();

    public String getPassword();

    public static enum Protocol {
        SMTP("SMTP", "smtp"),
        SMTPS("SMTP+SSL", "smtps"),
        SMTP_TLS("SMTP+TLS", "smtp");

        private String name;
        private String value;

        private Protocol(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public void processProps(Properties properties) {
            if (this == SMTP_TLS) {
                properties.put("mail.smtp.starttls.enable", (Object)true);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static Protocol fromName(String name) {
            if (name != null && name.length() > 0) {
                for (Protocol protocol : Protocol.values()) {
                    if (!protocol.name.equalsIgnoreCase(name)) continue;
                    return protocol;
                }
            }
            return null;
        }
    }
}

