/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.ldap.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.NamedItem;
import jetbrains.jetpass.auth.module.ldap.rest.client.api.LdapUserDetails;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.EmailJSON;
import jetbrains.jetpass.rest.dto.JabberJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="ldapdetails")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=LdapdetailsJSON.class)
public class LdapdetailsJSON
extends DetailsJSON
implements LdapUserDetails {
    @XmlElement(name="userid")
    private String userid;
    @XmlElement(name="fullName")
    private String fullName;
    @XmlElement(name="changePasswordUrl")
    private String changePasswordUrl;
    @XmlElement(name="jabber")
    private JabberJSON jabber;
    @XmlElement(name="VCSName")
    private String VCSName;
    @XmlElement(name="ldapGroupNames")
    private List<String> ldapGroupNames;

    public LdapdetailsJSON() {
    }

    public LdapdetailsJSON(@NotNull LdapUserDetails that) {
        NamedItem ref;
        this.setId(that.getId());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        if (that.getEmail() != null) {
            this.setEmail(new EmailJSON(that.getEmail()));
        }
        if (that.getAuthModule() != null) {
            ref = new AuthmoduleJSON();
            ((AuthmoduleJSON)ref).setId(that.getAuthModule().getId());
            this.setAuthModule((AuthmoduleJSON)ref);
        }
        this.setAuthModuleName(that.getAuthModuleName());
        if (that.getUser() != null) {
            ref = new UserJSON();
            ((AuthorityHolderJSON)ref).setId(that.getUser().getId());
            this.setUser((UserJSON)ref);
        }
        this.setLastAccessTime(that.getLastAccessTime());
        this.setLastAccessAddress(that.getLastAccessAddress());
        this.setLastAccessUserAgent(that.getLastAccessUserAgent());
        this.setUserid(that.getUserid());
        this.setFullName(that.getFullName());
        this.setChangePasswordUrl(that.getChangePasswordUrl());
        if (that.getJabber() != null) {
            this.setJabber(new JabberJSON(that.getJabber()));
        }
        this.setVCSName(that.getVCSName());
        this.setLdapGroupNames(this.getLdapGroupNames());
    }

    @Override
    @Nullable
    public String getUserid() {
        return this.userid;
    }

    @Override
    @Nullable
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @Nullable
    public String getChangePasswordUrl() {
        return this.changePasswordUrl;
    }

    @Override
    @Nullable
    public JabberJSON getJabber() {
        return this.jabber;
    }

    @Override
    @Nullable
    public String getVCSName() {
        return this.VCSName;
    }

    public List<String> getLdapGroupNames() {
        return this.ldapGroupNames;
    }

    @XmlTransient
    public void setUserid(@Nullable String userid) {
        this.userid = userid;
    }

    @XmlTransient
    public void setFullName(@Nullable String fullName) {
        this.fullName = fullName;
    }

    @XmlTransient
    public void setChangePasswordUrl(@Nullable String changePasswordUrl) {
        this.changePasswordUrl = changePasswordUrl;
    }

    @XmlTransient
    public void setJabber(@Nullable JabberJSON jabber) {
        this.jabber = jabber;
    }

    @XmlTransient
    public void setVCSName(@Nullable String VCSName) {
        this.VCSName = VCSName;
    }

    @XmlTransient
    public void setLdapGroupNames(@Nullable Iterable<String> ldapGroupNames) {
        this.ldapGroupNames = JsonUtils.iterableToList(ldapGroupNames);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LdapUserDetails)) {
            return false;
        }
        LdapUserDetails that = (LdapUserDetails)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static LdapdetailsJSON wrap(@NotNull LdapUserDetails that) {
        if (that instanceof LdapdetailsJSON) {
            return (LdapdetailsJSON)that;
        }
        return new LdapdetailsJSON(that);
    }
}

