/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.oauth2.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.NamedItem;
import jetbrains.jetpass.auth.module.oauth2.rest.client.api.OAuth2UserDetails;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.EmailJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="oauth2details")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=Oauth2detailsJSON.class)
public class Oauth2detailsJSON
extends DetailsJSON
implements OAuth2UserDetails {
    @XmlElement(name="identifier")
    private String identifier;
    @XmlElement(name="fullName")
    private String fullName;
    @XmlElement(name="avatar")
    private String avatar;

    public Oauth2detailsJSON() {
    }

    public Oauth2detailsJSON(@NotNull OAuth2UserDetails that) {
        NamedItem ref;
        this.setId(that.getId());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        if (that.getEmail() != null) {
            this.setEmail(new EmailJSON(that.getEmail()));
        }
        if (that.getAuthModule() != null) {
            ref = new AuthmoduleJSON();
            ((AuthmoduleJSON)ref).setId(that.getAuthModule().getId());
            this.setAuthModule((AuthmoduleJSON)ref);
        }
        this.setAuthModuleName(that.getAuthModuleName());
        if (that.getUser() != null) {
            ref = new UserJSON();
            ((AuthorityHolderJSON)ref).setId(that.getUser().getId());
            this.setUser((UserJSON)ref);
        }
        this.setLastAccessTime(that.getLastAccessTime());
        this.setLastAccessAddress(that.getLastAccessAddress());
        this.setLastAccessUserAgent(that.getLastAccessUserAgent());
        this.setIdentifier(that.getIdentifier());
        this.setFullName(that.getFullName());
        this.setAvatar(that.getAvatar());
    }

    @Override
    @Nullable
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @Nullable
    public String getAvatar() {
        return this.avatar;
    }

    @XmlTransient
    public void setIdentifier(@Nullable String identifier) {
        this.identifier = identifier;
    }

    @XmlTransient
    public void setFullName(@Nullable String fullName) {
        this.fullName = fullName;
    }

    @XmlTransient
    public void setAvatar(@Nullable String avatar) {
        this.avatar = avatar;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth2UserDetails)) {
            return false;
        }
        OAuth2UserDetails that = (OAuth2UserDetails)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static Oauth2detailsJSON wrap(@NotNull OAuth2UserDetails that) {
        if (that instanceof Oauth2detailsJSON) {
            return (Oauth2detailsJSON)that;
        }
        return new Oauth2detailsJSON(that);
    }
}

