/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.OAuth2TokenLoadException;
import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import com.intellij.hub.auth.oauth2.error.OAuthTokenErrorCode;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.UUID;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.AuthModuleClient;
import jetbrains.jetpass.client.accounts.CertificateClient;
import jetbrains.jetpass.client.accounts.DashboardClient;
import jetbrains.jetpass.client.accounts.EventClient;
import jetbrains.jetpass.client.accounts.HubFeatureClient;
import jetbrains.jetpass.client.accounts.ImportClient;
import jetbrains.jetpass.client.accounts.KeyStoreClient;
import jetbrains.jetpass.client.accounts.MetricClient;
import jetbrains.jetpass.client.accounts.OrganizationClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.PermissionClient;
import jetbrains.jetpass.client.accounts.ProjectClient;
import jetbrains.jetpass.client.accounts.ProjectRoleClient;
import jetbrains.jetpass.client.accounts.ProjectTeamClient;
import jetbrains.jetpass.client.accounts.ResourceClient;
import jetbrains.jetpass.client.accounts.RoleClient;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.accounts.ServiceCredentialsValidationResult;
import jetbrains.jetpass.client.accounts.SettingClient;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.client.accounts.UserDetailClient;
import jetbrains.jetpass.client.accounts.UserGroupClient;
import jetbrains.jetpass.client.accounts.WidgetClient;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.client.hub.HubURLBuilder;
import jetbrains.jetpass.client.resource.RequestValidator;
import jetbrains.jetpass.rest.dto.ErrorJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001J\u001b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0011\u0010\u0085\u0001\u001a\f\u0012\u0005\u0012\u00030\u0087\u0001\u0018\u00010\u0086\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0012\u0010+\u001a\u00020,X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0018\u00107\u001a\u000208X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0011\u0010A\u001a\u00020B8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0011\u0010E\u001a\u00020F8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0011\u0010I\u001a\u00020J8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0011\u0010M\u001a\u00020N8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u0013\u0010Q\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u001aR\u0011\u0010S\u001a\u00020T8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0011\u0010W\u001a\u00020X8F\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR\u0012\u0010[\u001a\u00020\\X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R\u0011\u0010_\u001a\u00020`8F\u00a2\u0006\u0006\u001a\u0004\ba\u0010bR\u0011\u0010c\u001a\u00020d8F\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0011\u0010g\u001a\u00020h8F\u00a2\u0006\u0006\u001a\u0004\bi\u0010jR\u0017\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010lR\u0011\u0010m\u001a\u00020n8F\u00a2\u0006\u0006\u001a\u0004\bo\u0010pR\u0011\u0010q\u001a\u00020r8F\u00a2\u0006\u0006\u001a\u0004\bs\u0010tR\u0011\u0010u\u001a\u00020v8F\u00a2\u0006\u0006\u001a\u0004\bw\u0010xR\u0011\u0010y\u001a\u00020z8F\u00a2\u0006\u0006\u001a\u0004\b{\u0010|R\u0012\u0010}\u001a\u00020~8F\u00a2\u0006\u0007\u001a\u0005\b\u007f\u0010\u0080\u0001\u00a8\u0006\u0088\u0001"}, d2={"Ljetbrains/jetpass/client/accounts/BaseAccountsClient;", "", "tokenHolder", "Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "(Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;)V", "authModuleClient", "Ljetbrains/jetpass/client/accounts/AuthModuleClient;", "getAuthModuleClient", "()Ljetbrains/jetpass/client/accounts/AuthModuleClient;", "baseURL", "", "getBaseURL", "()Ljava/lang/String;", "certificateClient", "Ljetbrains/jetpass/client/accounts/CertificateClient;", "getCertificateClient", "()Ljetbrains/jetpass/client/accounts/CertificateClient;", "client", "Ljavax/ws/rs/client/Client;", "getClient", "()Ljavax/ws/rs/client/Client;", "clientServiceId", "getClientServiceId", "connectTimeout", "", "getConnectTimeout", "()Ljava/lang/Integer;", "currentService", "Ljetbrains/jetpass/rest/dto/ServiceJSON;", "getCurrentService", "()Ljetbrains/jetpass/rest/dto/ServiceJSON;", "dashboardClient", "Ljetbrains/jetpass/client/accounts/DashboardClient;", "getDashboardClient", "()Ljetbrains/jetpass/client/accounts/DashboardClient;", "eventClient", "Ljetbrains/jetpass/client/accounts/EventClient;", "getEventClient", "()Ljetbrains/jetpass/client/accounts/EventClient;", "featureClient", "Ljetbrains/jetpass/client/accounts/HubFeatureClient;", "getFeatureClient", "()Ljetbrains/jetpass/client/accounts/HubFeatureClient;", "hubClient", "Ljetbrains/jetpass/client/hub/HubClient;", "getHubClient", "()Ljetbrains/jetpass/client/hub/HubClient;", "importClient", "Ljetbrains/jetpass/client/accounts/ImportClient;", "getImportClient", "()Ljetbrains/jetpass/client/accounts/ImportClient;", "metricsClient", "Ljetbrains/jetpass/client/accounts/MetricClient;", "getMetricsClient", "()Ljetbrains/jetpass/client/accounts/MetricClient;", "oAuthRequestValidator", "Ljetbrains/jetpass/client/resource/RequestValidator;", "getOAuthRequestValidator", "()Ljetbrains/jetpass/client/resource/RequestValidator;", "setOAuthRequestValidator", "(Ljetbrains/jetpass/client/resource/RequestValidator;)V", "organizationClient", "Ljetbrains/jetpass/client/accounts/OrganizationClient;", "getOrganizationClient", "()Ljetbrains/jetpass/client/accounts/OrganizationClient;", "permissionClient", "Ljetbrains/jetpass/client/accounts/PermissionClient;", "getPermissionClient", "()Ljetbrains/jetpass/client/accounts/PermissionClient;", "projectClient", "Ljetbrains/jetpass/client/accounts/ProjectClient;", "getProjectClient", "()Ljetbrains/jetpass/client/accounts/ProjectClient;", "projectRoleClient", "Ljetbrains/jetpass/client/accounts/ProjectRoleClient;", "getProjectRoleClient", "()Ljetbrains/jetpass/client/accounts/ProjectRoleClient;", "projectTeamClient", "Ljetbrains/jetpass/client/accounts/ProjectTeamClient;", "getProjectTeamClient", "()Ljetbrains/jetpass/client/accounts/ProjectTeamClient;", "readTimeout", "getReadTimeout", "resourceClient", "Ljetbrains/jetpass/client/accounts/ResourceClient;", "getResourceClient", "()Ljetbrains/jetpass/client/accounts/ResourceClient;", "roleClient", "Ljetbrains/jetpass/client/accounts/RoleClient;", "getRoleClient", "()Ljetbrains/jetpass/client/accounts/RoleClient;", "rootResource", "Ljavax/ws/rs/client/WebTarget;", "getRootResource", "()Ljavax/ws/rs/client/WebTarget;", "serviceClient", "Ljetbrains/jetpass/client/accounts/ServiceClient;", "getServiceClient", "()Ljetbrains/jetpass/client/accounts/ServiceClient;", "settingsClient", "Ljetbrains/jetpass/client/accounts/SettingClient;", "getSettingsClient", "()Ljetbrains/jetpass/client/accounts/SettingClient;", "storeClient", "Ljetbrains/jetpass/client/accounts/KeyStoreClient;", "getStoreClient", "()Ljetbrains/jetpass/client/accounts/KeyStoreClient;", "getTokenHolder", "()Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "urlBuilder", "Ljetbrains/jetpass/client/hub/HubURLBuilder;", "getUrlBuilder", "()Ljetbrains/jetpass/client/hub/HubURLBuilder;", "userClient", "Ljetbrains/jetpass/client/accounts/UserClient;", "getUserClient", "()Ljetbrains/jetpass/client/accounts/UserClient;", "userDetailClient", "Ljetbrains/jetpass/client/accounts/UserDetailClient;", "getUserDetailClient", "()Ljetbrains/jetpass/client/accounts/UserDetailClient;", "userGroupClient", "Ljetbrains/jetpass/client/accounts/UserGroupClient;", "getUserGroupClient", "()Ljetbrains/jetpass/client/accounts/UserGroupClient;", "widgetClient", "Ljetbrains/jetpass/client/accounts/WidgetClient;", "getWidgetClient", "()Ljetbrains/jetpass/client/accounts/WidgetClient;", "checkServiceCredentials", "Ljetbrains/jetpass/client/accounts/ServiceCredentialsValidationResult;", "getGuest", "Ljetbrains/jetpass/rest/dto/UserJSON;", "partial", "Ljetbrains/jetpass/client/accounts/Partial;", "Ljetbrains/jetpass/client/accounts/Partial$User;", "jetbrains.jetpass.client.accounts"})
public abstract class BaseAccountsClient {
    @Nullable
    private final TokenHolder<?> tokenHolder;

    @Nullable
    public final String getClientServiceId() {
        ServiceJSON serviceJSON = this.getCurrentService();
        return serviceJSON != null ? serviceJSON.getId() : null;
    }

    @Nullable
    public abstract String getBaseURL();

    @NotNull
    public abstract WebTarget getRootResource();

    @NotNull
    public abstract RequestValidator getOAuthRequestValidator();

    public abstract void setOAuthRequestValidator(@NotNull RequestValidator var1);

    @NotNull
    public abstract HubClient getHubClient();

    @NotNull
    public final HubURLBuilder getUrlBuilder() {
        return this.getHubClient().getURLBuilder();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ServiceCredentialsValidationResult checkServiceCredentials() {
        String baseURL;
        block23: {
            block22: {
                baseURL = this.getBaseURL();
                if (baseURL == null) break block22;
                CharSequence charSequence = baseURL;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block23;
            }
            return new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.EMPTY_URL, null, null, 6, null);
        }
        try {
            new URL(baseURL);
        }
        catch (MalformedURLException e) {
            return new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.MALFORMED_URL, ServiceCredentialsValidationResult.Status.MALFORMED_URL.getMessage(), e);
        }
        try {
            String scope2 = this.getHubClient().getOAuthClient().getHubScope();
            try {
                UUID.fromString(scope2);
            }
            catch (RuntimeException ex) {
                return new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.WRONG_URL, "Unknown target response: " + scope2, ex);
            }
        }
        catch (WebApplicationException e) {
            return new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.WRONG_URL, e.getMessage(), e);
        }
        catch (RuntimeException e) {
            Throwable nextCause;
            Throwable t = e;
            while (t instanceof RuntimeException && (nextCause = t.getCause()) != null && nextCause != t) {
                t = nextCause;
            }
            Throwable throwable = t;
            ServiceCredentialsValidationResult.Status status = throwable instanceof UnknownHostException ? ServiceCredentialsValidationResult.Status.UNKNOWN_HOST : (throwable instanceof ConnectException ? ServiceCredentialsValidationResult.Status.CANT_CONNECT : (throwable instanceof SocketTimeoutException ? ServiceCredentialsValidationResult.Status.TIMEOUT : ServiceCredentialsValidationResult.Status.CANT_CONNECT));
            return new ServiceCredentialsValidationResult(status, t.getMessage(), t);
        }
        TokenHolder<?> tokenHolder = this.tokenHolder;
        if (tokenHolder == null) {
            return new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.SERVICE_CREDENTIALS_UNDEFINED, null, null, 6, null);
        }
        TokenHolder<?> holder = tokenHolder;
        try {
            holder.getHeader();
            try {
                ServiceJSON theService = this.getCurrentService();
                return theService == null ? new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.SERVICE_NOT_REGISTERED, "Service was not found in Hub", null, 4, null) : (Intrinsics.areEqual((Object)theService.isTrusted(), (Object)true) ^ true ? new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.SERVICE_NOT_VERIFIED, ServiceCredentialsValidationResult.Status.SERVICE_NOT_VERIFIED.getMessage(), null, 4, null) : new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.OK, null, null, 6, null));
            }
            catch (WebApplicationException ex) {
                try {
                    ErrorJSON error = (ErrorJSON)ex.getResponse().readEntity(ErrorJSON.class);
                    if (error != null) {
                        String string = error.getError();
                        return Intrinsics.areEqual((Object)string, (Object)OAuthTokenErrorCode.INVALID_CLIENT.getAsciiCode()) ? new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.SERVICE_NOT_REGISTERED, ServiceCredentialsValidationResult.Status.SERVICE_NOT_REGISTERED.getMessage(), ex) : (Intrinsics.areEqual((Object)string, (Object)OAuthTokenErrorCode.UNAUTHORIZED_CLIENT.getAsciiCode()) ? new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.SERVICE_NOT_VERIFIED, ServiceCredentialsValidationResult.Status.SERVICE_NOT_VERIFIED.getMessage(), ex) : new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.OTHER, error.getError_description() == null ? "Error is " + error.getError() : error.getError_description(), ex));
                    }
                }
                catch (ProcessingException error) {
                    // empty catch block
                }
                Response response = ex.getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ex.response");
                return response.getStatusInfo() == Response.Status.FORBIDDEN ? new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.SERVICE_NOT_VERIFIED, ServiceCredentialsValidationResult.Status.SERVICE_NOT_VERIFIED.getMessage(), ex) : new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.CANT_CONNECT, ex.getMessage(), ex);
            }
        }
        catch (OAuth2TokenLoadException e) {
            void status;
            String string = e.getError();
            Pair pair = Intrinsics.areEqual((Object)string, (Object)OAuthTokenErrorCode.INVALID_CLIENT.getAsciiCode()) ? TuplesKt.to((Object)((Object)ServiceCredentialsValidationResult.Status.SERVICE_NOT_REGISTERED), (Object)("Service is not registered in Hub: " + e.getDescription())) : (Intrinsics.areEqual((Object)string, (Object)OAuthTokenErrorCode.INVALID_GRANT.getAsciiCode()) ? TuplesKt.to((Object)((Object)ServiceCredentialsValidationResult.Status.SERVICE_WRONG_SECRET), (Object)("Service secret is invalid: " + e.getDescription())) : (Intrinsics.areEqual((Object)string, (Object)OAuthTokenErrorCode.UNAUTHORIZED_CLIENT.getAsciiCode()) ? TuplesKt.to((Object)((Object)ServiceCredentialsValidationResult.Status.SERVICE_NOT_VERIFIED), (Object)e.getDescription()) : TuplesKt.to((Object)((Object)ServiceCredentialsValidationResult.Status.SERVICE_NOT_REGISTERED), (Object)(e.getError() + ": " + e.getDescription()))));
            ServiceCredentialsValidationResult.Status error = (ServiceCredentialsValidationResult.Status)((Object)pair.component1());
            String message = (String)pair.component2();
            return new ServiceCredentialsValidationResult((ServiceCredentialsValidationResult.Status)status, message, e);
        }
        catch (Exception e) {
            return new ServiceCredentialsValidationResult(ServiceCredentialsValidationResult.Status.CANT_CONNECT, e.getMessage(), e);
        }
    }

    private final ServiceJSON getCurrentService() {
        return this.getServiceClient().me((FieldPartial<Partial.Service>)Partial.service(Partial.Service.ID, Partial.Service.TRUSTED));
    }

    @NotNull
    public final Client getClient() {
        return this.getHubClient().getJerseyClient();
    }

    @Nullable
    public final Integer getConnectTimeout() {
        return (Integer)this.getClient().getConfiguration().getProperty("jersey.config.client.connectTimeout");
    }

    @Nullable
    public final Integer getReadTimeout() {
        return (Integer)this.getClient().getConfiguration().getProperty("jersey.config.client.readTimeout");
    }

    @NotNull
    public final EventClient getEventClient() {
        return new EventClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final UserClient getUserClient() {
        return new UserClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final UserGroupClient getUserGroupClient() {
        return new UserGroupClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final ServiceClient getServiceClient() {
        return new ServiceClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final SettingClient getSettingsClient() {
        return new SettingClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final RoleClient getRoleClient() {
        return new RoleClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final AuthModuleClient getAuthModuleClient() {
        return new AuthModuleClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final ProjectClient getProjectClient() {
        return new ProjectClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final ResourceClient getResourceClient() {
        return new ResourceClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final KeyStoreClient getStoreClient() {
        return new KeyStoreClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final CertificateClient getCertificateClient() {
        return new CertificateClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final MetricClient getMetricsClient() {
        return new MetricClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final PermissionClient getPermissionClient() {
        return new PermissionClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final ProjectRoleClient getProjectRoleClient() {
        return new ProjectRoleClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final UserDetailClient getUserDetailClient() {
        return new UserDetailClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final ImportClient getImportClient() {
        return new ImportClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final HubFeatureClient getFeatureClient() {
        return new HubFeatureClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final WidgetClient getWidgetClient() {
        return new WidgetClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final ProjectTeamClient getProjectTeamClient() {
        return new ProjectTeamClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final OrganizationClient getOrganizationClient() {
        return new OrganizationClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final DashboardClient getDashboardClient() {
        return new DashboardClient(this.getRootResource(), this.tokenHolder);
    }

    @NotNull
    public final UserJSON getGuest(@Nullable Partial<Partial.User> partial) {
        return this.getUserClient().guest((FieldPartial<Partial.User>)partial);
    }

    @Nullable
    public final TokenHolder<?> getTokenHolder() {
        return this.tokenHolder;
    }

    protected BaseAccountsClient(@Nullable TokenHolder<?> tokenHolder) {
        this.tokenHolder = tokenHolder;
    }
}

