/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.HubClientSubResourceUtilKt;
import jetbrains.jetpass.client.accounts.HubClientUtilKt;
import jetbrains.jetpass.client.accounts.HubResourceUtilKt;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.OrganizationJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0005&'()*B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ(\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\fR\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006+"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient;", "", "rootResource", "Ljavax/ws/rs/client/WebTarget;", "tokenHolder", "Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "(Ljavax/ws/rs/client/WebTarget;Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;)V", "resource", "kotlin.jvm.PlatformType", "getTokenHolder", "()Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "createOrganization", "Ljetbrains/jetpass/rest/dto/OrganizationJSON;", "newOrganization", "partial", "Ljetbrains/jetpass/client/FieldPartial;", "Ljetbrains/jetpass/client/accounts/Partial$Organization;", "deleteOrganization", "", "organizationId", "", "successorId", "getGroupsClient", "Ljetbrains/jetpass/client/accounts/OrganizationClient$GroupClient;", "getOrganization", "getOrganizationPage", "Ljetbrains/jetpass/client/accounts/OrganizationClient$Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "getProjectsClient", "Ljetbrains/jetpass/client/accounts/OrganizationClient$ProjectClient;", "orgId", "getTeamsClient", "Ljetbrains/jetpass/client/accounts/OrganizationClient$TeamClient;", "getUsersClient", "Ljetbrains/jetpass/client/accounts/OrganizationClient$UserClient;", "updateOrganization", "patch", "GroupClient", "Page", "ProjectClient", "TeamClient", "UserClient", "jetbrains.jetpass.client.accounts"})
public class OrganizationClient {
    private final WebTarget resource;
    @Nullable
    private final TokenHolder<?> tokenHolder;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OrganizationJSON createOrganization(@NotNull OrganizationJSON newOrganization, @Nullable FieldPartial<Partial.Organization> partial) {
        void $this$createResource$iv;
        Intrinsics.checkParameterIsNotNull((Object)newOrganization, (String)"newOrganization");
        WebTarget webTarget = this.resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
        WebTarget webTarget2 = webTarget;
        TokenHolder<?> tokenHolder$iv = this.tokenHolder;
        boolean $i$f$createResource = false;
        return (OrganizationJSON)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default((WebTarget)$this$createResource$iv, partial, false, 2, null)), tokenHolder$iv).post(Entity.json((Object)newOrganization), OrganizationJSON.class);
    }

    public static /* synthetic */ OrganizationJSON createOrganization$default(OrganizationClient organizationClient, OrganizationJSON organizationJSON, FieldPartial fieldPartial, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createOrganization");
        }
        if ((n & 2) != 0) {
            fieldPartial = Partial.organization(Partial.Organization.ID);
        }
        return organizationClient.createOrganization(organizationJSON, fieldPartial);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final OrganizationJSON getOrganization(@NotNull String organizationId, @Nullable FieldPartial<Partial.Organization> partial) {
        Object object;
        void $this$getResourceById$iv;
        Intrinsics.checkParameterIsNotNull((Object)organizationId, (String)"organizationId");
        WebTarget webTarget = this.resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
        WebTarget webTarget2 = webTarget;
        TokenHolder<?> tokenHolder$iv = this.tokenHolder;
        boolean $i$f$getResourceById = false;
        void var6_6 = $this$getResourceById$iv;
        String byProperty$iv$iv = null;
        boolean $i$f$getResource = false;
        try {
            void $this$getResource$iv$iv;
            object = HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default(HubClientUtilKt.id(HubClientUtilKt.byProperty((WebTarget)$this$getResource$iv$iv, byProperty$iv$iv), organizationId), partial, false, 2, null)), tokenHolder$iv).get(OrganizationJSON.class);
        }
        catch (WebApplicationException ex$iv$iv) {
            Response response = ex$iv$iv.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ex.response");
            if (response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                throw (Throwable)ex$iv$iv;
            }
            object = null;
        }
        return (OrganizationJSON)object;
    }

    public static /* synthetic */ OrganizationJSON getOrganization$default(OrganizationClient organizationClient, String string, FieldPartial fieldPartial, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOrganization");
        }
        if ((n & 2) != 0) {
            fieldPartial = Partial.organization(Partial.Organization.ID);
        }
        return organizationClient.getOrganization(string, fieldPartial);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page getOrganizationPage(@Nullable BaseFilter<?> filter2, @Nullable FieldPartial<Partial.Organization> partial) {
        void $this$getResourcePage$iv;
        WebTarget webTarget = this.resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
        WebTarget webTarget2 = webTarget;
        TokenHolder<?> tokenHolder$iv = this.tokenHolder;
        boolean $i$f$getResourcePage = false;
        BaseFilter<?> baseFilter = filter2;
        return (Page)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam(HubClientUtilKt.pageParams((WebTarget)$this$getResourcePage$iv, filter2), partial, baseFilter != null ? baseFilter.isTotalRequested() : false)), tokenHolder$iv).get(Page.class);
    }

    public static /* synthetic */ Page getOrganizationPage$default(OrganizationClient organizationClient, BaseFilter baseFilter, FieldPartial fieldPartial, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOrganizationPage");
        }
        if ((n & 1) != 0) {
            baseFilter = null;
        }
        if ((n & 2) != 0) {
            fieldPartial = Partial.organization(Partial.Organization.ID);
        }
        return organizationClient.getOrganizationPage(baseFilter, fieldPartial);
    }

    public final void updateOrganization(@NotNull String organizationId, @NotNull OrganizationJSON patch) {
        Intrinsics.checkParameterIsNotNull((Object)organizationId, (String)"organizationId");
        Intrinsics.checkParameterIsNotNull((Object)patch, (String)"patch");
        WebTarget webTarget = this.resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
        HubResourceUtilKt.updateResource(webTarget, organizationId, patch, this.tokenHolder);
    }

    public final void deleteOrganization(@NotNull String organizationId, @Nullable String successorId) {
        Intrinsics.checkParameterIsNotNull((Object)organizationId, (String)"organizationId");
        WebTarget webTarget = this.resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
        HubResourceUtilKt.deleteResource(webTarget, organizationId, successorId, this.tokenHolder);
    }

    @NotNull
    public final ProjectClient getProjectsClient(@NotNull String orgId) {
        Intrinsics.checkParameterIsNotNull((Object)orgId, (String)"orgId");
        WebTarget webTarget = this.resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
        return new ProjectClient(HubClientUtilKt.id(webTarget, orgId), this.tokenHolder);
    }

    @NotNull
    public final UserClient getUsersClient(@NotNull String organizationId) {
        Intrinsics.checkParameterIsNotNull((Object)organizationId, (String)"organizationId");
        WebTarget webTarget = this.resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
        return new UserClient(HubClientUtilKt.id(webTarget, organizationId), this.tokenHolder);
    }

    @NotNull
    public final GroupClient getGroupsClient(@NotNull String organizationId) {
        Intrinsics.checkParameterIsNotNull((Object)organizationId, (String)"organizationId");
        WebTarget webTarget = this.resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
        return new GroupClient(HubClientUtilKt.id(webTarget, organizationId), this.tokenHolder);
    }

    @NotNull
    public final TeamClient getTeamsClient(@NotNull String organizationId) {
        Intrinsics.checkParameterIsNotNull((Object)organizationId, (String)"organizationId");
        WebTarget webTarget = this.resource;
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
        return new TeamClient(HubClientUtilKt.id(webTarget, organizationId), this.tokenHolder);
    }

    @Nullable
    public final TokenHolder<?> getTokenHolder() {
        return this.tokenHolder;
    }

    public OrganizationClient(@NotNull WebTarget rootResource, @Nullable TokenHolder<?> tokenHolder) {
        Intrinsics.checkParameterIsNotNull((Object)rootResource, (String)"rootResource");
        this.tokenHolder = tokenHolder;
        this.resource = rootResource.path("organizations");
    }

    public /* synthetic */ OrganizationClient(WebTarget webTarget, TokenHolder tokenHolder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tokenHolder = null;
        }
        this(webTarget, tokenHolder);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005R\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient$Page;", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/BasePage;", "Ljetbrains/jetpass/rest/dto/OrganizationJSON;", "()V", "organizations", "", "getItems", "getOrganizations", "jetbrains.jetpass.client.accounts"})
    public static final class Page
    extends BasePage<OrganizationJSON> {
        @XmlElement(name="organizations")
        private final List<OrganizationJSON> organizations;

        @NotNull
        public final List<OrganizationJSON> getOrganizations() {
            List list2 = this.organizations;
            boolean bl = false;
            List list3 = list2;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            return list3;
        }

        @Override
        @NotNull
        public List<OrganizationJSON> getItems() {
            List list2 = this.organizations;
            boolean bl = false;
            List list3 = list2;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            return list3;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J(\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015R\u0019\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient$GroupClient;", "", "idResource", "Ljavax/ws/rs/client/WebTarget;", "tokenHolder", "Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "(Ljavax/ws/rs/client/WebTarget;Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;)V", "resource", "kotlin.jvm.PlatformType", "getResource", "()Ljavax/ws/rs/client/WebTarget;", "getTokenHolder", "()Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "addGroup", "Ljetbrains/jetpass/rest/dto/UserGroupJSON;", "groupJSON", "partial", "Ljetbrains/jetpass/client/FieldPartial;", "Ljetbrains/jetpass/client/accounts/Partial$UserGroup;", "getGroup", "groupId", "", "getGroupPage", "Ljetbrains/jetpass/client/accounts/OrganizationClient$GroupClient$Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "removeGroup", "", "Page", "jetbrains.jetpass.client.accounts"})
    public static final class GroupClient {
        private final WebTarget resource;
        @Nullable
        private final TokenHolder<?> tokenHolder;

        public final WebTarget getResource() {
            return this.resource;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UserGroupJSON addGroup(@NotNull UserGroupJSON groupJSON, @Nullable FieldPartial<Partial.UserGroup> partial) {
            void $this$addSubresource$iv;
            Intrinsics.checkParameterIsNotNull((Object)groupJSON, (String)"groupJSON");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$addSubresource = false;
            return (UserGroupJSON)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default((WebTarget)$this$addSubresource$iv, partial, false, 2, null)), tokenHolder$iv).post(Entity.json((Object)groupJSON), UserGroupJSON.class);
        }

        public static /* synthetic */ UserGroupJSON addGroup$default(GroupClient groupClient, UserGroupJSON userGroupJSON, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 2) != 0) {
                fieldPartial = Partial.userGroup(Partial.UserGroup.ID);
            }
            return groupClient.addGroup(userGroupJSON, fieldPartial);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Page getGroupPage(@Nullable BaseFilter<?> filter2, @Nullable FieldPartial<Partial.UserGroup> partial) {
            void $this$getSubresourcePage$iv;
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$getSubresourcePage = false;
            BaseFilter<?> baseFilter = filter2;
            return (Page)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam(HubClientUtilKt.pageParams((WebTarget)$this$getSubresourcePage$iv, filter2), partial, baseFilter != null ? baseFilter.isTotalRequested() : false)), tokenHolder$iv).get(Page.class);
        }

        public static /* synthetic */ Page getGroupPage$default(GroupClient groupClient, BaseFilter baseFilter, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 1) != 0) {
                baseFilter = null;
            }
            if ((n & 2) != 0) {
                fieldPartial = Partial.userGroup(Partial.UserGroup.ID);
            }
            return groupClient.getGroupPage(baseFilter, fieldPartial);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UserGroupJSON getGroup(@NotNull String groupId, @Nullable FieldPartial<Partial.UserGroup> partial) {
            void $this$getSubresource$iv;
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$getSubresource = false;
            return (UserGroupJSON)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default(HubClientUtilKt.id((WebTarget)$this$getSubresource$iv, groupId), partial, false, 2, null)), tokenHolder$iv).get(UserGroupJSON.class);
        }

        public static /* synthetic */ UserGroupJSON getGroup$default(GroupClient groupClient, String string, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 2) != 0) {
                fieldPartial = Partial.userGroup(Partial.UserGroup.ID);
            }
            return groupClient.getGroup(string, fieldPartial);
        }

        public final void removeGroup(@NotNull String groupId) {
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            HubClientSubResourceUtilKt.removeSubresource(webTarget, groupId, this.tokenHolder);
        }

        @Nullable
        public final TokenHolder<?> getTokenHolder() {
            return this.tokenHolder;
        }

        public GroupClient(@NotNull WebTarget idResource, @Nullable TokenHolder<?> tokenHolder) {
            Intrinsics.checkParameterIsNotNull((Object)idResource, (String)"idResource");
            this.tokenHolder = tokenHolder;
            this.resource = idResource.path("groups");
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016R\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient$GroupClient$Page;", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/BasePage;", "Ljetbrains/jetpass/rest/dto/UserGroupJSON;", "()V", "groups", "", "getGroups", "getItems", "jetbrains.jetpass.client.accounts"})
        public static final class Page
        extends BasePage<UserGroupJSON> {
            @XmlElement(name="groups")
            private final List<UserGroupJSON> groups;

            @NotNull
            public final List<UserGroupJSON> getGroups() {
                List list2 = this.groups;
                boolean bl = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                return list3;
            }

            @Override
            @NotNull
            public List<UserGroupJSON> getItems() {
                List list2 = this.groups;
                boolean bl = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                return list3;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J(\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016R\u0019\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient$TeamClient;", "", "idResource", "Ljavax/ws/rs/client/WebTarget;", "tokenHolder", "Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "(Ljavax/ws/rs/client/WebTarget;Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;)V", "resource", "kotlin.jvm.PlatformType", "getResource", "()Ljavax/ws/rs/client/WebTarget;", "getTokenHolder", "()Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "addTeam", "Ljetbrains/jetpass/rest/dto/ProjectTeamJSON;", "teamJSON", "partial", "Ljetbrains/jetpass/client/FieldPartial;", "Ljetbrains/jetpass/client/accounts/Partial$ProjectTeam;", "getTeam", "Ljetbrains/jetpass/rest/dto/UserGroupJSON;", "teamId", "", "getTeamPage", "Ljetbrains/jetpass/client/accounts/OrganizationClient$TeamClient$Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "removeTeam", "", "Page", "jetbrains.jetpass.client.accounts"})
    public static final class TeamClient {
        private final WebTarget resource;
        @Nullable
        private final TokenHolder<?> tokenHolder;

        public final WebTarget getResource() {
            return this.resource;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProjectTeamJSON addTeam(@NotNull ProjectTeamJSON teamJSON, @Nullable FieldPartial<Partial.ProjectTeam> partial) {
            void $this$addSubresource$iv;
            Intrinsics.checkParameterIsNotNull((Object)teamJSON, (String)"teamJSON");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$addSubresource = false;
            return (ProjectTeamJSON)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default((WebTarget)$this$addSubresource$iv, partial, false, 2, null)), tokenHolder$iv).post(Entity.json((Object)teamJSON), ProjectTeamJSON.class);
        }

        public static /* synthetic */ ProjectTeamJSON addTeam$default(TeamClient teamClient, ProjectTeamJSON projectTeamJSON, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 2) != 0) {
                fieldPartial = Partial.projectTeam(Partial.ProjectTeam.ID);
            }
            return teamClient.addTeam(projectTeamJSON, fieldPartial);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Page getTeamPage(@Nullable BaseFilter<?> filter2, @Nullable FieldPartial<Partial.ProjectTeam> partial) {
            void $this$getSubresourcePage$iv;
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$getSubresourcePage = false;
            BaseFilter<?> baseFilter = filter2;
            return (Page)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam(HubClientUtilKt.pageParams((WebTarget)$this$getSubresourcePage$iv, filter2), partial, baseFilter != null ? baseFilter.isTotalRequested() : false)), tokenHolder$iv).get(Page.class);
        }

        public static /* synthetic */ Page getTeamPage$default(TeamClient teamClient, BaseFilter baseFilter, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 1) != 0) {
                baseFilter = null;
            }
            if ((n & 2) != 0) {
                fieldPartial = Partial.projectTeam(Partial.ProjectTeam.ID);
            }
            return teamClient.getTeamPage(baseFilter, fieldPartial);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UserGroupJSON getTeam(@NotNull String teamId, @Nullable FieldPartial<Partial.ProjectTeam> partial) {
            void $this$getSubresource$iv;
            Intrinsics.checkParameterIsNotNull((Object)teamId, (String)"teamId");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$getSubresource = false;
            return (UserGroupJSON)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default(HubClientUtilKt.id((WebTarget)$this$getSubresource$iv, teamId), partial, false, 2, null)), tokenHolder$iv).get(UserGroupJSON.class);
        }

        public static /* synthetic */ UserGroupJSON getTeam$default(TeamClient teamClient, String string, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 2) != 0) {
                fieldPartial = Partial.projectTeam(Partial.ProjectTeam.ID);
            }
            return teamClient.getTeam(string, fieldPartial);
        }

        public final void removeTeam(@NotNull String teamId) {
            Intrinsics.checkParameterIsNotNull((Object)teamId, (String)"teamId");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            HubClientSubResourceUtilKt.removeSubresource(webTarget, teamId, this.tokenHolder);
        }

        @Nullable
        public final TokenHolder<?> getTokenHolder() {
            return this.tokenHolder;
        }

        public TeamClient(@NotNull WebTarget idResource, @Nullable TokenHolder<?> tokenHolder) {
            Intrinsics.checkParameterIsNotNull((Object)idResource, (String)"idResource");
            this.tokenHolder = tokenHolder;
            this.resource = idResource.path("teams");
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016R\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient$TeamClient$Page;", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/BasePage;", "Ljetbrains/jetpass/rest/dto/ProjectTeamJSON;", "()V", "teams", "", "getGroups", "getItems", "jetbrains.jetpass.client.accounts"})
        public static final class Page
        extends BasePage<ProjectTeamJSON> {
            @XmlElement(name="teams")
            private final List<ProjectTeamJSON> teams;

            @NotNull
            public final List<ProjectTeamJSON> getGroups() {
                List list2 = this.teams;
                boolean bl = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                return list3;
            }

            @Override
            @NotNull
            public List<ProjectTeamJSON> getItems() {
                List list2 = this.teams;
                boolean bl = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                return list3;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J(\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015R\u0019\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient$UserClient;", "", "idResource", "Ljavax/ws/rs/client/WebTarget;", "tokenHolder", "Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "(Ljavax/ws/rs/client/WebTarget;Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;)V", "resource", "kotlin.jvm.PlatformType", "getResource", "()Ljavax/ws/rs/client/WebTarget;", "getTokenHolder", "()Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "addUser", "Ljetbrains/jetpass/rest/dto/UserJSON;", "userJSON", "partial", "Ljetbrains/jetpass/client/FieldPartial;", "Ljetbrains/jetpass/client/accounts/Partial$User;", "getUser", "userId", "", "getUserPage", "Ljetbrains/jetpass/client/accounts/OrganizationClient$UserClient$Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "removeUser", "", "Page", "jetbrains.jetpass.client.accounts"})
    public static final class UserClient {
        private final WebTarget resource;
        @Nullable
        private final TokenHolder<?> tokenHolder;

        public final WebTarget getResource() {
            return this.resource;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UserJSON addUser(@NotNull UserJSON userJSON, @Nullable FieldPartial<Partial.User> partial) {
            void $this$addSubresource$iv;
            Intrinsics.checkParameterIsNotNull((Object)userJSON, (String)"userJSON");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$addSubresource = false;
            return (UserJSON)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default((WebTarget)$this$addSubresource$iv, partial, false, 2, null)), tokenHolder$iv).post(Entity.json((Object)userJSON), UserJSON.class);
        }

        public static /* synthetic */ UserJSON addUser$default(UserClient userClient, UserJSON userJSON, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 2) != 0) {
                fieldPartial = Partial.user(Partial.User.ID);
            }
            return userClient.addUser(userJSON, fieldPartial);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Page getUserPage(@Nullable BaseFilter<?> filter2, @Nullable FieldPartial<Partial.User> partial) {
            void $this$getSubresourcePage$iv;
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$getSubresourcePage = false;
            BaseFilter<?> baseFilter = filter2;
            return (Page)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam(HubClientUtilKt.pageParams((WebTarget)$this$getSubresourcePage$iv, filter2), partial, baseFilter != null ? baseFilter.isTotalRequested() : false)), tokenHolder$iv).get(Page.class);
        }

        public static /* synthetic */ Page getUserPage$default(UserClient userClient, BaseFilter baseFilter, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 1) != 0) {
                baseFilter = null;
            }
            if ((n & 2) != 0) {
                fieldPartial = Partial.user(Partial.User.ID);
            }
            return userClient.getUserPage(baseFilter, fieldPartial);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UserJSON getUser(@NotNull String userId, @Nullable FieldPartial<Partial.User> partial) {
            void $this$getSubresource$iv;
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$getSubresource = false;
            return (UserJSON)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default(HubClientUtilKt.id((WebTarget)$this$getSubresource$iv, userId), partial, false, 2, null)), tokenHolder$iv).get(UserJSON.class);
        }

        public static /* synthetic */ UserJSON getUser$default(UserClient userClient, String string, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 2) != 0) {
                fieldPartial = Partial.user(Partial.User.ID);
            }
            return userClient.getUser(string, fieldPartial);
        }

        public final void removeUser(@NotNull String userId) {
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            HubClientSubResourceUtilKt.removeSubresource(webTarget, userId, this.tokenHolder);
        }

        @Nullable
        public final TokenHolder<?> getTokenHolder() {
            return this.tokenHolder;
        }

        public UserClient(@NotNull WebTarget idResource, @Nullable TokenHolder<?> tokenHolder) {
            Intrinsics.checkParameterIsNotNull((Object)idResource, (String)"idResource");
            this.tokenHolder = tokenHolder;
            this.resource = idResource.path("users");
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005R\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient$UserClient$Page;", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/BasePage;", "Ljetbrains/jetpass/rest/dto/UserJSON;", "()V", "users", "", "getItems", "getUsers", "jetbrains.jetpass.client.accounts"})
        public static final class Page
        extends BasePage<UserJSON> {
            @XmlElement(name="users")
            private final List<UserJSON> users;

            @NotNull
            public final List<UserJSON> getUsers() {
                List list2 = this.users;
                boolean bl = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                return list3;
            }

            @Override
            @NotNull
            public List<UserJSON> getItems() {
                List list2 = this.users;
                boolean bl = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                return list3;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J(\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015R\u0019\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient$ProjectClient;", "", "idResource", "Ljavax/ws/rs/client/WebTarget;", "tokenHolder", "Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "(Ljavax/ws/rs/client/WebTarget;Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;)V", "resource", "kotlin.jvm.PlatformType", "getResource", "()Ljavax/ws/rs/client/WebTarget;", "getTokenHolder", "()Lcom/intellij/hub/auth/oauth2/consumer/TokenHolder;", "addProject", "Ljetbrains/jetpass/rest/dto/ProjectJSON;", "projectJSON", "partial", "Ljetbrains/jetpass/client/FieldPartial;", "Ljetbrains/jetpass/client/accounts/Partial$Project;", "getProject", "projectId", "", "getProjectPage", "Ljetbrains/jetpass/client/accounts/OrganizationClient$ProjectClient$Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "removeProject", "", "Page", "jetbrains.jetpass.client.accounts"})
    public static final class ProjectClient {
        private final WebTarget resource;
        @Nullable
        private final TokenHolder<?> tokenHolder;

        public final WebTarget getResource() {
            return this.resource;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProjectJSON addProject(@NotNull ProjectJSON projectJSON, @Nullable FieldPartial<Partial.Project> partial) {
            void $this$addSubresource$iv;
            Intrinsics.checkParameterIsNotNull((Object)projectJSON, (String)"projectJSON");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$addSubresource = false;
            return (ProjectJSON)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default((WebTarget)$this$addSubresource$iv, partial, false, 2, null)), tokenHolder$iv).post(Entity.json((Object)projectJSON), ProjectJSON.class);
        }

        public static /* synthetic */ ProjectJSON addProject$default(ProjectClient projectClient, ProjectJSON projectJSON, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 2) != 0) {
                fieldPartial = Partial.project(Partial.Project.ID);
            }
            return projectClient.addProject(projectJSON, fieldPartial);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Page getProjectPage(@Nullable BaseFilter<?> filter2, @Nullable FieldPartial<Partial.Project> partial) {
            void $this$getSubresourcePage$iv;
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$getSubresourcePage = false;
            BaseFilter<?> baseFilter = filter2;
            return (Page)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam(HubClientUtilKt.pageParams((WebTarget)$this$getSubresourcePage$iv, filter2), partial, baseFilter != null ? baseFilter.isTotalRequested() : false)), tokenHolder$iv).get(Page.class);
        }

        public static /* synthetic */ Page getProjectPage$default(ProjectClient projectClient, BaseFilter baseFilter, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 1) != 0) {
                baseFilter = null;
            }
            if ((n & 2) != 0) {
                fieldPartial = Partial.project(Partial.Project.ID);
            }
            return projectClient.getProjectPage(baseFilter, fieldPartial);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProjectJSON getProject(@NotNull String projectId, @Nullable FieldPartial<Partial.Project> partial) {
            void $this$getSubresource$iv;
            Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            WebTarget webTarget2 = webTarget;
            TokenHolder<?> tokenHolder$iv = this.tokenHolder;
            boolean $i$f$getSubresource = false;
            return (ProjectJSON)HubClientUtilKt.authenticate(HubClientUtilKt.requestJSON(HubClientUtilKt.fieldsParam$default(HubClientUtilKt.id((WebTarget)$this$getSubresource$iv, projectId), partial, false, 2, null)), tokenHolder$iv).get(ProjectJSON.class);
        }

        public static /* synthetic */ ProjectJSON getProject$default(ProjectClient projectClient, String string, FieldPartial fieldPartial, int n, Object object) {
            if ((n & 2) != 0) {
                fieldPartial = Partial.project(Partial.Project.ID);
            }
            return projectClient.getProject(string, fieldPartial);
        }

        public final void removeProject(@NotNull String projectId) {
            Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
            WebTarget webTarget = this.resource;
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"resource");
            HubClientSubResourceUtilKt.removeSubresource(webTarget, projectId, this.tokenHolder);
        }

        @Nullable
        public final TokenHolder<?> getTokenHolder() {
            return this.tokenHolder;
        }

        public ProjectClient(@NotNull WebTarget idResource, @Nullable TokenHolder<?> tokenHolder) {
            Intrinsics.checkParameterIsNotNull((Object)idResource, (String)"idResource");
            this.tokenHolder = tokenHolder;
            this.resource = idResource.path("projects");
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005R\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/jetpass/client/accounts/OrganizationClient$ProjectClient$Page;", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/BasePage;", "Ljetbrains/jetpass/rest/dto/ProjectJSON;", "()V", "projects", "", "getItems", "getProjects", "jetbrains.jetpass.client.accounts"})
        public static final class Page
        extends BasePage<ProjectJSON> {
            @XmlElement(name="projects")
            private final List<ProjectJSON> projects;

            @NotNull
            public final List<ProjectJSON> getProjects() {
                List list2 = this.projects;
                boolean bl = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                return list3;
            }

            @Override
            @NotNull
            public List<ProjectJSON> getItems() {
                List list2 = this.projects;
                boolean bl = false;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                return list3;
            }
        }
    }
}

