/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.api;

import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.ring.license.InvalidLicenseException;
import jetbrains.ring.license.checker.CantBanGuestException;
import jetbrains.ring.license.checker.CantChangeLogoException;
import jetbrains.ring.license.checker.InvalidBuildException;
import jetbrains.ring.license.checker.InvalidMajorVersionException;
import jetbrains.ring.license.checker.InvalidMinorVersionException;
import jetbrains.ring.license.checker.InvalidProductException;
import jetbrains.ring.license.checker.LicenseDiskSpaceExceededException;
import jetbrains.ring.license.checker.LicenseExpiredException;
import jetbrains.ring.license.checker.LicenseUserNumberExceededException;
import jetbrains.ring.license.checker.NotGeneratedLicenseException;
import jetbrains.ring.license.checker.NotHostedLicenseException;
import jetbrains.ring.license.checker.NotStandaloneLicenseException;
import jetbrains.ring.license.checker.UpgradeExpiredException;
import jetbrains.ring.license.reader.EmptyLicenseKeyException;
import jetbrains.ring.license.reader.EmptyLicenseNameException;
import jetbrains.ring.license.reader.InvalidLicenseFormatException;
import jetbrains.ring.license.reader.InvalidLicenseNameException;
import jetbrains.ring.license.reader.InvalidLicenseSignatureException;
import jetbrains.ring.license.reader.UnknownLicenseTypeException;
import jetbrains.ring.license.reader.UnknownProductException;
import org.jetbrains.annotations.NotNull;

public class LicenseViolationException
extends DataAccessException {
    public static final String NAME_FIELD = "licenseName";
    public static final String KEY_FIELD = "licenseKey";
    private final String field;

    public LicenseViolationException(InvalidLicenseException e) {
        super(e.getMessage(), e);
        this.field = KEY_FIELD;
    }

    public LicenseViolationException(@NotNull String code, @NotNull String message, @NotNull String field, @NotNull Throwable cause) {
        super(code, message, cause);
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    @NotNull
    public static LicenseViolationException wrapEmptyLicenseNameException(@NotNull EmptyLicenseNameException emptyLicenseNameException) {
        return new LicenseViolationException("license_empty_name", emptyLicenseNameException.getMessage(), NAME_FIELD, emptyLicenseNameException);
    }

    @NotNull
    public static LicenseViolationException wrapUnknownLicenseTypeException(@NotNull UnknownLicenseTypeException unknownLicenseTypeException) {
        return new LicenseViolationException("license_unknown_type", unknownLicenseTypeException.getMessage(), KEY_FIELD, unknownLicenseTypeException);
    }

    @NotNull
    public static LicenseViolationException wrapInvalidLicenseFormatException(@NotNull InvalidLicenseFormatException invalidLicenseFormatException) {
        return new LicenseViolationException("license_invalid_format", invalidLicenseFormatException.getMessage(), KEY_FIELD, invalidLicenseFormatException);
    }

    @NotNull
    public static LicenseViolationException wrapInvalidLicenseSignatureException(@NotNull InvalidLicenseSignatureException invalidLicenseSignatureException) {
        return new LicenseViolationException("license_invalid_signature", invalidLicenseSignatureException.getMessage(), KEY_FIELD, invalidLicenseSignatureException);
    }

    @NotNull
    public static LicenseViolationException wrapEmptyLicenseKeyException(@NotNull EmptyLicenseKeyException emptyLicenseKeyException) {
        return new LicenseViolationException("license_empty_key", emptyLicenseKeyException.getMessage(), KEY_FIELD, emptyLicenseKeyException);
    }

    @NotNull
    public static LicenseViolationException wrapInvalidLicenseNameException(@NotNull InvalidLicenseNameException invalidLicenseNameException) {
        return new LicenseViolationException("license_invalid_name", invalidLicenseNameException.getMessage(), NAME_FIELD, invalidLicenseNameException);
    }

    @NotNull
    public static LicenseViolationException wrapUnknownProductException(@NotNull UnknownProductException unknownProductException) {
        return new LicenseViolationException("license_unknown_product", unknownProductException.getMessage(), KEY_FIELD, unknownProductException);
    }

    @NotNull
    public static LicenseViolationException wrapInvalidBuildException(@NotNull InvalidBuildException invalidBuildException) {
        return new LicenseViolationException("license_invalid_build", invalidBuildException.getMessage(), KEY_FIELD, invalidBuildException);
    }

    @NotNull
    public static LicenseViolationException wrapInvalidMajorVersionException(@NotNull InvalidMajorVersionException invalidMajorVersionException) {
        return new LicenseViolationException("license_invalid_major_version", invalidMajorVersionException.getMessage(), KEY_FIELD, invalidMajorVersionException);
    }

    @NotNull
    public static LicenseViolationException wrapInvalidProductException(@NotNull InvalidProductException invalidProductException) {
        return new LicenseViolationException("license_invalid_product", invalidProductException.getMessage(), KEY_FIELD, invalidProductException);
    }

    @NotNull
    public static LicenseViolationException wrapUpgradeExpiredException(@NotNull UpgradeExpiredException upgradeExpiredException) {
        return new LicenseViolationException("license_upgrade_expired", upgradeExpiredException.getMessage(), KEY_FIELD, upgradeExpiredException);
    }

    @NotNull
    public static LicenseViolationException wrapNotGeneratedLicenseException(@NotNull NotGeneratedLicenseException notGeneratedLicenseException) {
        return new LicenseViolationException("license_not_generated_yet", notGeneratedLicenseException.getMessage(), KEY_FIELD, notGeneratedLicenseException);
    }

    @NotNull
    public static LicenseViolationException wrapCantChangeLogoException(@NotNull CantChangeLogoException cantChangeLogoException) {
        return new LicenseViolationException("license_cant_change_logo", cantChangeLogoException.getMessage(), KEY_FIELD, cantChangeLogoException);
    }

    @NotNull
    public static LicenseViolationException wrapLicenseDiskSpaceExceededException(@NotNull LicenseDiskSpaceExceededException licenseDiskSpaceExceededException) {
        return new LicenseViolationException("license_disk_space_exceeded", licenseDiskSpaceExceededException.getMessage(), KEY_FIELD, licenseDiskSpaceExceededException);
    }

    @NotNull
    public static LicenseViolationException wrapNotHostedLicenseException(@NotNull NotHostedLicenseException notHostedLicenseException) {
        return new LicenseViolationException("license_not_hosted", notHostedLicenseException.getMessage(), KEY_FIELD, notHostedLicenseException);
    }

    @NotNull
    public static LicenseViolationException wrapLicenseExpiredException(@NotNull LicenseExpiredException licenseExpiredException) {
        return new LicenseViolationException("license_expired", licenseExpiredException.getMessage(), KEY_FIELD, licenseExpiredException);
    }

    @NotNull
    public static LicenseViolationException wrapLicenseUserNumberExceededException(@NotNull LicenseUserNumberExceededException licenseUserNumberExceededException) {
        return new LicenseViolationException("license_users_number_exceeded", licenseUserNumberExceededException.getMessage(), KEY_FIELD, licenseUserNumberExceededException);
    }

    @NotNull
    public static LicenseViolationException wrapNotStandaloneLicenseException(@NotNull NotStandaloneLicenseException notStandaloneLicenseException) {
        return new LicenseViolationException("license_not_standalone", notStandaloneLicenseException.getMessage(), KEY_FIELD, notStandaloneLicenseException);
    }

    @NotNull
    public static LicenseViolationException wrapCantBanGuestException(@NotNull CantBanGuestException cantBanGuestException) {
        return new LicenseViolationException("license_cant_ban_guest", cantBanGuestException.getMessage(), KEY_FIELD, cantBanGuestException);
    }

    @NotNull
    public static LicenseViolationException wrapInvalidMinorVersionException(@NotNull InvalidMinorVersionException invalidMinorVersionException) {
        return new LicenseViolationException("license_invalid_minor_version", invalidMinorVersionException.getMessage(), KEY_FIELD, invalidMinorVersionException);
    }
}

