/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.jetpass.dao.api.DataAccessException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecurityViolationException
extends DataAccessException {
    public SecurityViolationException(String code, String message, Map<String, String> params2) {
        super(code, message);
        this.setParameters(params2);
        this.setSeverity(DataAccessException.Severity.INFO);
    }

    public SecurityViolationException(String code, String message) {
        super(code, message);
        this.setSeverity(DataAccessException.Severity.INFO);
    }

    public SecurityViolationException(String code, String message, Throwable cause) {
        super(code, message, cause);
        this.setSeverity(DataAccessException.Severity.INFO);
    }

    public SecurityViolationException(String code, String message, Throwable cause, Map<String, String> params2) {
        super(code, message, cause, params2);
        this.setSeverity(DataAccessException.Severity.INFO);
    }

    @NotNull
    public static SecurityViolationException cantBanSelf() {
        return new SecurityViolationException("restricted-guest-ban", "User can't change his own ban status");
    }

    @NotNull
    public static SecurityViolationException cantUpdateGuest() {
        return new SecurityViolationException("restricted-guest-update", "Guest is not updatable");
    }

    @NotNull
    public static SecurityViolationException addFavoriteProjectForGuest() {
        return new SecurityViolationException("restricted-guest-add-favorite-project", "Cannot add project to favorites of guest user");
    }

    @NotNull
    public static SecurityViolationException removeFavoriteProjectForGuest() {
        return new SecurityViolationException("restricted-guest-remove-favorite-project", "Cannot remove project from favorites of guest user");
    }

    @NotNull
    public static SecurityViolationException permanentTokenForGuest() {
        return new SecurityViolationException("restricted-guest-create-permanent-token", "Cannot create permanent token for guest");
    }

    @NotNull
    public static SecurityViolationException appPasswordTokenForGuest() {
        return new SecurityViolationException("restricted-guest-create-application-password", "Cannot create application password for guest");
    }

    @NotNull
    public static SecurityViolationException guestCantCreateProject() {
        return new SecurityViolationException("restricted-guest-create-project", "Guest users are not allowed to create projects");
    }

    @NotNull
    public static SecurityViolationException guestCantOwnProject() {
        return new SecurityViolationException("restricted-guest-own-project", "Guest users are not allowed to be a project owner");
    }

    @NotNull
    public static SecurityViolationException cantMergeUnverifiedEmails() {
        return new SecurityViolationException("restricted-merge-unverified-emails", "Cannot merge users with unverified email addresses");
    }

    @NotNull
    public static SecurityViolationException cantReadPersonalDataOfAnotherUser() {
        return new SecurityViolationException("restricted-not-self-read-personal-data", "Cannot read personal data of another user. Read User Full and Low-level Admin Read permissions are required.");
    }

    @NotNull
    public static SecurityViolationException permanentTokenForAnotherUser() {
        return new SecurityViolationException("restricted-not-enough-permissions-for-create-permanent-token", "You don't have sufficient access permissions to create a permament token on behalf of this user");
    }

    @NotNull
    public static SecurityViolationException appPasswordTokenForAnotherUser() {
        return new SecurityViolationException("restricted-not-self-create-application-password", "Only user them selves can create application passwords");
    }

    @NotNull
    public static SecurityViolationException cantUpdateAnotherService() {
        return new SecurityViolationException("restricted-another-service-update", "Only service itself can update its vendor, applicationName, version, and releaseDate");
    }

    @NotNull
    public static SecurityViolationException oldPasswordMismatch(String username) {
        return new SecurityViolationException("old_password_mismatch", "Cannot update password for user " + username + ", because entered old password does not match actual old password", Collections.singletonMap("username", username));
    }

    public static SecurityViolationException noUpdateProjectPermission(@NotNull String permissionName, @Nullable String projectName) {
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("action", permissionName);
        params2.put("project", projectName);
        return new SecurityViolationException("no-update-project-permission-is-given", "You have no permission [" + permissionName + "] in project [" + projectName + "]", params2);
    }

    @NotNull
    public static SecurityViolationException restrictedOperation(@NotNull String operation, @NotNull String apiType, @NotNull Map<String, String> entityKeys) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Operation ").append(operation).append(" for ").append(apiType);
        if (!entityKeys.isEmpty()) {
            messageBuilder.append(" with");
            for (Map.Entry<String, String> key : entityKeys.entrySet()) {
                messageBuilder.append(' ').append(key.getKey()).append(" \"").append(key.getValue()).append("\"");
            }
        }
        messageBuilder.append(" is not permitted");
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("type", apiType);
        params2.put("operation", operation);
        params2.putAll(entityKeys);
        return new SecurityViolationException("restricted-operation", messageBuilder.toString(), params2);
    }
}

