/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.api.permissionCache;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import jetbrains.jetpass.api.NamedItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.dao.api.ServiceDAO;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQueryImpl;
import jetbrains.jetpass.dao.api.security.PermissionDAO;
import jetbrains.jetpass.dao.api.security.ProjectDAO;
import jetbrains.jetpass.sequence.Sequence;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016J\u0011\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/jetpass/dao/api/permissionCache/ServicePermissionQuery;", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionQueryImpl;", "globalProjectUUID", "", "trusted", "", "accessibleProjects", "", "grantedPermissions", "(Ljava/lang/String;ZLjava/util/Set;Ljava/util/Set;)V", "getAccessibleProjects", "()Ljava/util/Set;", "accessibleProjectsUnordered", "getAccessibleProjectsUnordered", "getGrantedPermissions", "grantedPermissionsUnordered", "getGrantedPermissionsUnordered", "grantedRoles", "getGrantedRoles", "grantedRolesUnordered", "getGrantedRolesUnordered", "canAccess", "canAccessGlobal", "clone", "contains", "that", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionQuery;", "Companion", "jetbrains.jetpass.dao"})
public final class ServicePermissionQuery
extends PermissionQueryImpl {
    private final boolean trusted;
    @NotNull
    private final Set<String> accessibleProjects;
    @NotNull
    private final Set<String> grantedPermissions;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean canAccess() {
        return this.trusted;
    }

    @Override
    public boolean canAccessGlobal() {
        return this.trusted;
    }

    @Override
    @NotNull
    public Set<String> getAccessibleProjectsUnordered() {
        return this.getAccessibleProjects();
    }

    @Override
    @NotNull
    public Set<String> getGrantedRoles() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<String> getGrantedRolesUnordered() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<String> getGrantedPermissionsUnordered() {
        return this.getGrantedPermissions();
    }

    @Override
    @NotNull
    public PermissionQueryImpl clone() {
        return new ServicePermissionQuery(this.getGlobalProjectUUID(), this.trusted, this.getAccessibleProjectsUnordered(), this.getGrantedPermissions()).copy(this);
    }

    @Override
    public boolean contains(@NotNull PermissionQuery that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return this.trusted;
    }

    @Override
    @NotNull
    public Set<String> getAccessibleProjects() {
        return this.accessibleProjects;
    }

    @Override
    @NotNull
    public Set<String> getGrantedPermissions() {
        return this.grantedPermissions;
    }

    private ServicePermissionQuery(String globalProjectUUID2, boolean trusted, Set<String> accessibleProjects, Set<String> grantedPermissions) {
        super(globalProjectUUID2);
        this.trusted = trusted;
        this.accessibleProjects = accessibleProjects;
        this.grantedPermissions = grantedPermissions;
    }

    public /* synthetic */ ServicePermissionQuery(String globalProjectUUID2, boolean trusted, Set accessibleProjects, Set grantedPermissions, DefaultConstructorMarker $constructor_marker) {
        this(globalProjectUUID2, trusted, accessibleProjects, grantedPermissions);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\r\u001a\"\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\b0\b0\u000ej\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\b0\b`\u0010*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/dao/api/permissionCache/ServicePermissionQuery$Companion;", "", "()V", "create", "Ljetbrains/jetpass/dao/api/permissionCache/ServicePermissionQuery;", "serviceDAO", "Ljetbrains/jetpass/dao/api/ServiceDAO;", "serviceID", "", "projectDAO", "Ljetbrains/jetpass/dao/api/security/ProjectDAO;", "permissionDAO", "Ljetbrains/jetpass/dao/api/security/PermissionDAO;", "toIds", "Ljava/util/LinkedHashSet;", "kotlin.jvm.PlatformType", "Lkotlin/collections/LinkedHashSet;", "Ljetbrains/jetpass/sequence/Sequence;", "Ljetbrains/jetpass/api/NamedItem;", "jetbrains.jetpass.dao"})
    public static final class Companion {
        @NotNull
        public final ServicePermissionQuery create(@NotNull ServiceDAO serviceDAO, @NotNull String serviceID, @NotNull ProjectDAO projectDAO, @NotNull PermissionDAO permissionDAO) {
            Set set;
            Set set2;
            Intrinsics.checkParameterIsNotNull((Object)serviceDAO, (String)"serviceDAO");
            Intrinsics.checkParameterIsNotNull((Object)serviceID, (String)"serviceID");
            Intrinsics.checkParameterIsNotNull((Object)projectDAO, (String)"projectDAO");
            Intrinsics.checkParameterIsNotNull((Object)permissionDAO, (String)"permissionDAO");
            Object t = serviceDAO.get(serviceID);
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"serviceDAO.get(serviceID)!!");
            Boolean trusted = ((Service)t).isTrusted();
            Project project = projectDAO.getGlobal();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"projectDAO.global");
            String string = project.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectDAO.global.id");
            Boolean bl = trusted;
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"trusted");
            boolean bl2 = bl;
            if (trusted.booleanValue()) {
                Sequence<Project> sequence = projectDAO.getAllItems();
                Intrinsics.checkExpressionValueIsNotNull(sequence, (String)"projectDAO.allItems");
                set2 = Collections.unmodifiableSet((Set)this.toIds(sequence));
            } else {
                set2 = SetsKt.emptySet();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"if (trusted) Collections\u2026.toIds()) else emptySet()");
            if (trusted.booleanValue()) {
                Sequence sequence = permissionDAO.getAllItems();
                Intrinsics.checkExpressionValueIsNotNull(sequence, (String)"permissionDAO.allItems");
                set = Collections.unmodifiableSet((Set)this.toIds(sequence));
            } else {
                set = SetsKt.emptySet();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"if (trusted) Collections\u2026.toIds()) else emptySet()");
            return new ServicePermissionQuery(string, bl2, set2, set, null);
        }

        /*
         * WARNING - void declaration
         */
        private final LinkedHashSet<String> toIds(@NotNull Sequence<? extends NamedItem> $this$toIds) {
            void var3_4;
            void $this$mapTo$iv;
            Iterable $this$sortedBy$iv = $this$toIds;
            boolean $i$f$sortedBy = false;
            Iterable iterable = $this$sortedBy$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    NamedItem it = (NamedItem)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (NamedItem)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                NamedItem namedItem = (NamedItem)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                String string = it.getId();
                collection.add(string);
            }
            return (LinkedHashSet)var3_4;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

