/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.remote.api.event;

import java.util.Calendar;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.event.Change;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.dao.remote.api.event.MergedEvent$WhenMappings;
import jetbrains.jetpass.dao.remote.api.event.RemoteEventDAO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bH\u0016J\u0010\u0010\f\u001a\n \n*\u0004\u0018\u00010\r0\rH\u0016J\u0010\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\r0\rH\u0016J\u0010\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\r0\rH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\n \n*\u0004\u0018\u00010\r0\rH\u0016J\u0010\u0010\u0015\u001a\n \n*\u0004\u0018\u00010\r0\rH\u0016J\u0010\u0010\u0016\u001a\n \n*\u0004\u0018\u00010\r0\rH\u0016J\u0010\u0010\u0017\u001a\n \n*\u0004\u0018\u00010\r0\rH\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/jetpass/dao/remote/api/event/MergedEvent;", "Ljetbrains/jetpass/api/event/Event;", "base", "merged", "(Ljetbrains/jetpass/api/event/Event;Ljetbrains/jetpass/api/event/Event;)V", "deep", "", "getAliases", "", "Ljetbrains/jetpass/api/Alias;", "kotlin.jvm.PlatformType", "", "getAuthor", "", "getAuthorPresentation", "getAuthorType", "getChanges", "Ljetbrains/jetpass/api/event/Change;", "getEraseTimestamp", "Ljava/util/Calendar;", "getId", "getTargetId", "getTargetPresentation", "getTargetType", "getTimestamp", "getType", "Companion", "jetbrains.jetpass.dao.remote"})
public final class MergedEvent
implements Event {
    private final int deep;
    private final Event base;
    private final Event merged;
    private static final int MERGED_EVENT_DEEP = 50;
    public static final Companion Companion = new Companion(null);

    @Override
    public String getTargetId() {
        return this.base.getTargetId();
    }

    @Override
    public String getTargetType() {
        return this.base.getTargetType();
    }

    @Override
    public String getTargetPresentation() {
        return this.base.getTargetPresentation();
    }

    @NotNull
    public Iterable<Change> getChanges() {
        Iterable<? extends Change> iterable = this.base.getChanges();
        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"base.changes");
        Sequence sequence = CollectionsKt.asSequence(iterable);
        Iterable<? extends Change> iterable2 = this.merged.getChanges();
        Intrinsics.checkExpressionValueIsNotNull(iterable2, (String)"merged.changes");
        return SequencesKt.asIterable((Sequence)SequencesKt.plus((Sequence)sequence, (Sequence)CollectionsKt.asSequence(iterable2)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getType() {
        Event.Type baseType = Event.Type.fromString(this.base.getType());
        Event.Type mergedType = Event.Type.fromString(this.merged.getType());
        Event.Type type = baseType;
        if (type != null) {
            switch (MergedEvent$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    String string = mergedType.getName();
                    String string2 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mergedType.getName()");
                    return string2;
                }
                case 2: {
                    String string = baseType.getName();
                    String string2 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"baseType.getName()");
                    return string2;
                }
                case 3: {
                    String string = mergedType == Event.Type.REMOVE ? mergedType.getName() : baseType.getName();
                    String string2 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (mergedType == Event.\u2026tName()\n                }");
                    return string2;
                }
            }
        }
        String string = baseType.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"baseType.getName()");
        return string;
    }

    @Override
    @NotNull
    public Calendar getTimestamp() {
        Calendar calendar;
        Calendar baseDate = this.base.getTimestamp();
        Calendar mergedDate = this.merged.getTimestamp();
        if (mergedDate.before(baseDate)) {
            Calendar calendar2 = baseDate;
            calendar = calendar2;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"baseDate");
        } else {
            Calendar calendar3 = mergedDate;
            calendar = calendar3;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar3, (String)"mergedDate");
        }
        return calendar;
    }

    @Override
    @Nullable
    public Calendar getEraseTimestamp() {
        Calendar baseDate = this.base.getEraseTimestamp();
        Calendar mergedDate = this.merged.getEraseTimestamp();
        return mergedDate == null ? baseDate : (baseDate == null ? mergedDate : (mergedDate.before(baseDate) ? baseDate : mergedDate));
    }

    @Override
    public String getAuthor() {
        return this.base.getAuthor();
    }

    @Override
    public String getAuthorPresentation() {
        return this.base.getAuthorPresentation();
    }

    @Override
    public String getAuthorType() {
        return this.base.getAuthorType();
    }

    @Override
    public String getId() {
        return this.base.getId();
    }

    public Iterable<Alias> getAliases() {
        return this.base.getAliases();
    }

    public MergedEvent(@NotNull Event base, @NotNull Event merged) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)merged, (String)"merged");
        this.base = base;
        this.merged = merged;
        int deep = 0;
        if (this.base instanceof MergedEvent && (deep = ((MergedEvent)this.base).deep + 1) > MERGED_EVENT_DEEP) {
            Companion.getLogger().warn((Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return "Merged event has deep more than " + MERGED_EVENT_DEEP + " please check events for target id: " + merged.getTargetId() + ". Current event: " + RemoteEventDAO.Companion.printEvent(merged);
                }
            });
        }
        this.deep = deep;
    }

    static {
        MERGED_EVENT_DEEP = 50;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/dao/remote/api/event/MergedEvent$Companion;", "Lmu/KLogging;", "()V", "MERGED_EVENT_DEEP", "", "jetbrains.jetpass.dao.remote"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

