/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.remote.api.event;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.EventClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.event.EventDAO;
import jetbrains.jetpass.dao.remote.api.PageIterator;
import jetbrains.jetpass.dao.remote.api.RemoteDAO;
import jetbrains.jetpass.dao.remote.api.event.MergedEvent;
import jetbrains.jetpass.dao.remote.api.event.RemoteEventDAO;
import jetbrains.jetpass.rest.dto.EventJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.Page;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u0000 &2\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002:\u0001&B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J \u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0014J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0014J\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0004H\u0014J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ljetbrains/jetpass/dao/remote/api/event/RemoteEventDAO;", "Ljetbrains/jetpass/dao/api/event/EventDAO;", "Ljetbrains/jetpass/dao/remote/api/RemoteDAO;", "Ljetbrains/jetpass/api/event/Event;", "Ljetbrains/jetpass/rest/dto/EventJSON;", "Ljetbrains/jetpass/client/accounts/Partial$Event;", "client", "Ljetbrains/jetpass/client/accounts/EventClient;", "(Ljetbrains/jetpass/client/accounts/EventClient;)V", "getClient", "()Ljetbrains/jetpass/client/accounts/EventClient;", "setClient", "lastFetchedEventId", "Ljava/util/concurrent/atomic/AtomicLong;", "createPartial", "Ljetbrains/jetpass/client/FieldPartial;", "fieldName", "", "delete", "", "id", "doSync", "syncStartTime", "", "fetchItem", "partial", "fetchPage", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "init", "newJSON", "onNewItem", "dto", "syncDelta", "", "toJSON", "item", "Companion", "jetbrains.jetpass.dao.remote"})
public final class RemoteEventDAO
extends RemoteDAO<Event, EventJSON, Partial.Event>
implements EventDAO {
    private final AtomicLong lastFetchedEventId;
    @NotNull
    private EventClient client;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected Page<EventJSON> fetchPage(@NotNull BaseFilter<?> filter2, @NotNull FieldPartial<Partial.Event> partial) {
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getEventPage(filter2, partial);
    }

    @Override
    @Nullable
    protected EventJSON fetchItem(@NotNull String id, @NotNull FieldPartial<Partial.Event> partial) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getEvent(id, partial);
    }

    @Override
    @NotNull
    public FieldPartial<Partial.Event> createPartial(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Partial<Partial.Event> partial = Partial.event(new Partial.Event(fieldName));
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.event(Partial.Event(fieldName))");
        return partial;
    }

    @Override
    @NotNull
    public EventJSON newJSON(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        EventJSON eventJSON = new EventJSON();
        boolean bl = false;
        boolean bl2 = false;
        EventJSON $this$apply = eventJSON;
        boolean bl3 = false;
        $this$apply.setId(id);
        return eventJSON;
    }

    @Override
    @NotNull
    public EventJSON toJSON(@NotNull Event item2) {
        Intrinsics.checkParameterIsNotNull((Object)item2, (String)"item");
        EventJSON eventJSON = EventJSON.wrap(item2);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventJSON, (String)"EventJSON.wrap(item)");
        return eventJSON;
    }

    @Override
    public void delete(@NotNull String id) throws DataAccessException {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        throw (Throwable)new UnsupportedOperationException("Event deletion is prohibited!");
    }

    @Override
    protected void doSync(long syncStartTime) {
        this.syncDelta();
    }

    @NotNull
    public final Iterable<Event> syncDelta() {
        long afterEventId = this.lastFetchedEventId.get();
        String query2 = "afterId: {" + afterEventId + '}';
        Companion.getLogger().debug((Function0)new Function0<String>(query2){
            final /* synthetic */ String $query;

            @NotNull
            public final String invoke() {
                return "Getting new events for query: " + this.$query;
            }
            {
                this.$query = string;
                super(0);
            }
        });
        Object filter2 = this.filter().query(query2);
        PageIterator iter = this.createIterator((BaseFilter<?>)filter2, this.getDefaultPartial());
        LinkedHashMap newEvents = new LinkedHashMap(1);
        Iterator $this$forEach$iv = iter;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Event event;
            Object element$iv = iterator3.next();
            EventJSON dto = (EventJSON)element$iv;
            boolean bl2 = false;
            this.onNewItem(dto);
            Object i = this.putRemoteItem(this.getDataStore(), (IdItem)dto, this.getDefaultPartial());
            if (i == null) {
                Intrinsics.throwNpe();
            }
            Event newEvent2 = (Event)i;
            Companion.getLogger().debug((Function0)new Function0<String>(newEvent2){
                final /* synthetic */ Event $newEvent;

                @NotNull
                public final String invoke() {
                    return "New Event: " + RemoteEventDAO.Companion.printEvent(this.$newEvent);
                }
                {
                    this.$newEvent = event;
                    super(0);
                }
            });
            String id = newEvent2.getTargetId();
            if ((Event)newEvents.get(id) != null) {
                Event event2;
                boolean bl3 = false;
                boolean bl4 = false;
                Event existentEvent = event2;
                boolean bl5 = false;
                Event event3 = existentEvent;
                Intrinsics.checkExpressionValueIsNotNull((Object)event3, (String)"existentEvent");
                event = new MergedEvent(event3, newEvent2);
            } else {
                event = newEvent2;
            }
            Event event4 = event;
            Map map = newEvents;
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            map.put(string, event4);
        }
        if (newEvents.isEmpty()) {
            Companion.getLogger().trace((Function0)new Function0<String>(query2){
                final /* synthetic */ String $query;

                @NotNull
                public final String invoke() {
                    return "No events received for query: " + this.$query;
                }
                {
                    this.$query = string;
                    super(0);
                }
            });
        } else {
            Companion.getLogger().debug((Function0)new Function0<String>(newEvents){
                final /* synthetic */ LinkedHashMap $newEvents;

                @NotNull
                public final String invoke() {
                    return "New events received: " + this.$newEvents.size();
                }
                {
                    this.$newEvents = linkedHashMap;
                    super(0);
                }
            });
            Companion.getLogger().debug((Function0)new Function0<String>(newEvents){
                final /* synthetic */ LinkedHashMap $newEvents;

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("New merged events: \n\t");
                    Collection<V> collection = this.$newEvents.values();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"newEvents.values");
                    return stringBuilder.append(jetbrains.jetpass.dao.remote.api.event.RemoteEventDAO$Companion.access$dumpEvents(RemoteEventDAO.Companion, collection)).toString();
                }
                {
                    this.$newEvents = linkedHashMap;
                    super(0);
                }
            });
        }
        Collection collection = newEvents.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"newEvents.values");
        return collection;
    }

    public final void init() {
        Event first = (Event)this.getAllItems().orderBy("id", false).first();
        if (first != null && first.getId() != null) {
            Companion.getLogger().debug((Function0)new Function0<String>(first){
                final /* synthetic */ Event $first;

                @NotNull
                public final String invoke() {
                    return "First seen event id was: " + this.$first.getId();
                }
                {
                    this.$first = event;
                    super(0);
                }
            });
            String string = first.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"first.id");
            String string2 = string;
            AtomicLong atomicLong = this.lastFetchedEventId;
            boolean bl = false;
            long l = Long.parseLong(string2);
            atomicLong.set(l);
        } else {
            Companion.getLogger().debug((Function0)init.2.INSTANCE);
        }
    }

    @Override
    protected void onNewItem(@NotNull EventJSON dto) {
        Intrinsics.checkParameterIsNotNull((Object)dto, (String)"dto");
        String string = dto.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dto.id!!");
        String string2 = string;
        boolean bl = false;
        long newId = Long.parseLong(string2);
        long oldId = this.lastFetchedEventId.get();
        if (newId > oldId) {
            this.lastFetchedEventId.set(newId);
        }
    }

    @NotNull
    public final EventClient getClient() {
        return this.client;
    }

    public final void setClient(@NotNull EventClient eventClient) {
        Intrinsics.checkParameterIsNotNull((Object)eventClient, (String)"<set-?>");
        this.client = eventClient;
    }

    public RemoteEventDAO(@NotNull EventClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Partial<Partial.Event> partial = Partial.event(Partial.Event.ID, Partial.Event.TARGET_TYPE, Partial.Event.TARGET_ID, Partial.Event.TYPE);
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.event(\n         \u2026      Partial.Event.TYPE)");
        super((FieldPartial)partial);
        this.client = client;
        this.lastFetchedEventId = new AtomicLong(-1L);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Ljetbrains/jetpass/dao/remote/api/event/RemoteEventDAO$Companion;", "Lmu/KLogging;", "()V", "dumpEvents", "", "events", "", "Ljetbrains/jetpass/api/event/Event;", "printEvent", "event", "jetbrains.jetpass.dao.remote"})
    public static final class Companion
    extends KLogging {
        private final String dumpEvents(Iterable<? extends Event> events) {
            return CollectionsKt.joinToString$default(events, (CharSequence)"\n\t", null, null, (int)0, null, (Function1)dumpEvents.1.INSTANCE, (int)30, null);
        }

        @NotNull
        public final String printEvent(@NotNull Event event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            return event.getType() + ':' + event.getTargetType() + ':' + event.getTargetId();
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$dumpEvents(Companion $this, Iterable events) {
            return $this.dumpEvents(events);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

