/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.remote.api.settings;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.settings.BackupSettings;
import jetbrains.jetpass.api.settings.ImportSettings;
import jetbrains.jetpass.api.settings.InternalSettings;
import jetbrains.jetpass.api.settings.JabberSettings;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.api.settings.PublicSettings;
import jetbrains.jetpass.api.settings.SMTPMessage;
import jetbrains.jetpass.api.settings.SMTPSettings;
import jetbrains.jetpass.api.settings.Settings;
import jetbrains.jetpass.api.settings.ThrottlingSettings;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.SettingClient;
import jetbrains.jetpass.dao.api.settings.SettingsDAO;
import jetbrains.jetpass.dao.remote.api.RemoteDAO;
import jetbrains.jetpass.dao.remote.api.RemoteItemAccessor;
import jetbrains.jetpass.dao.remote.api.RemoteMutableDAO;
import jetbrains.jetpass.dao.remote.api.util.ItemRemoteRelationEnd;
import jetbrains.jetpass.dao.remote.api.util.RemoteRelationEnd;
import jetbrains.jetpass.rest.dto.BackupSettingsJSON;
import jetbrains.jetpass.rest.dto.BackupStatusJSON;
import jetbrains.jetpass.rest.dto.ImportSettingsJSON;
import jetbrains.jetpass.rest.dto.InternalSettingsJSON;
import jetbrains.jetpass.rest.dto.JabberSettingsJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.PublicSettingsJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.SmtpMessageJSON;
import jetbrains.jetpass.rest.dto.SmtpSettingsJSON;
import jetbrains.jetpass.rest.dto.ThrottlingSettingsJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.Page;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0014J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010\u001aH\u0014J\u0018\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0004H\u0014J \u0010(\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0014J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0014J\n\u0010-\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010.\u001a\u00020/H\u0016J\u001a\u00100\u001a\u0002H1\"\n\b\u0000\u00101\u0018\u0001*\u00020\u0003H\u0082\b\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\u001e\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u0006\u00108\u001a\u00020\u0004H\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u0015H\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\u001fH\u0016J\u0010\u0010C\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u001aH\u0016J\u0018\u0010D\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J \u0010D\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\u001aH\u0016J\u0018\u0010I\u001a\u00020#2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020FH\u0016J\u0010\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020\u001aH\u0016J\u0010\u0010O\u001a\u00020#2\u0006\u0010P\u001a\u00020\u001aH\u0016J\u0018\u0010Q\u001a\u00020#2\u0006\u0010R\u001a\u00020\u00032\u0006\u0010S\u001a\u00020\u001aH\u0002J\u0010\u0010T\u001a\u00020\u00042\u0006\u0010U\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\bR-\u0010\f\u001a\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000e\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006V"}, d2={"Ljetbrains/jetpass/dao/remote/api/settings/RemoteSettingsDAO;", "Ljetbrains/jetpass/dao/api/settings/SettingsDAO;", "Ljetbrains/jetpass/dao/remote/api/RemoteMutableDAO;", "Ljetbrains/jetpass/api/settings/Settings;", "Ljetbrains/jetpass/rest/dto/SettingsJSON;", "Ljetbrains/jetpass/client/accounts/Partial$Settings;", "client", "Ljetbrains/jetpass/client/accounts/SettingClient;", "(Ljetbrains/jetpass/client/accounts/SettingClient;)V", "getClient", "()Ljetbrains/jetpass/client/accounts/SettingClient;", "setClient", "settingsItemAccessor", "", "Ljava/lang/Class;", "Ljetbrains/jetpass/dao/remote/api/RemoteItemAccessor;", "getSettingsItemAccessor", "()Ljava/util/Map;", "addAutoJoinGroup", "Ljetbrains/jetpass/api/authority/UserGroup;", "license", "Ljetbrains/jetpass/api/settings/LicenseSettings;", "group", "backup", "Ljetbrains/jetpass/api/settings/BackupSettings$Status;", "targetVersion", "", "createPartial", "Ljetbrains/jetpass/client/FieldPartial;", "fieldName", "doCreate", "", "json", "partial", "doDelete", "", "id", "successor", "doUpdate", "change", "fetchItem", "fetchPage", "Ljetbrains/mps/webr/rpc/rest/json/common/runtime/Page;", "filter", "Ljetbrains/jetpass/client/BaseFilter;", "getAvailableLocales", "getBackupSettings", "Ljetbrains/jetpass/api/settings/BackupSettings;", "getByType", "S", "()Ljetbrains/jetpass/api/settings/Settings;", "getImportSettings", "Ljetbrains/jetpass/api/settings/ImportSettings;", "getInternalSettings", "Ljetbrains/jetpass/api/settings/InternalSettings;", "getItemAccessor", "dto", "getJabberSettings", "Ljetbrains/jetpass/api/settings/JabberSettings;", "getLicenseSettings", "getPublicSettings", "Ljetbrains/jetpass/api/settings/PublicSettings;", "getSMTPSettings", "Ljetbrains/jetpass/api/settings/SMTPSettings;", "getThrottlingSettings", "Ljetbrains/jetpass/api/settings/ThrottlingSettings;", "getUpdateStatus", "newJSON", "removeAutoJoinGroup", "keepUsers", "", "reset", "settingID", "sendSMTPMessage", "message", "Ljetbrains/jetpass/api/settings/SMTPMessage;", "requireEmailVerification", "testEmail", "email", "testJabber", "jabber", "testSettings", "settings", "contact", "toJSON", "item", "jetbrains.jetpass.dao.remote"})
public final class RemoteSettingsDAO
extends RemoteMutableDAO<Settings, SettingsJSON, Partial.Settings>
implements SettingsDAO {
    @NotNull
    private final Map<Class<? extends SettingsJSON>, RemoteItemAccessor<?, ?>> settingsItemAccessor;
    @NotNull
    private SettingClient client;

    @NotNull
    public final Map<Class<? extends SettingsJSON>, RemoteItemAccessor<?, ?>> getSettingsItemAccessor() {
        return this.settingsItemAccessor;
    }

    @Override
    @NotNull
    protected Void doCreate(@NotNull SettingsJSON json, @NotNull FieldPartial<Partial.Settings> partial) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    protected void doUpdate(@NotNull String id, @NotNull SettingsJSON change) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        this.client.updateSetting(id, change);
    }

    @Override
    protected void doDelete(@NotNull String id, @Nullable String successor) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.client.deleteSetting(id, successor);
    }

    @Override
    @NotNull
    public SettingsJSON toJSON(@NotNull Settings item2) {
        SettingsJSON settingsJSON;
        Intrinsics.checkParameterIsNotNull((Object)item2, (String)"item");
        Settings settings = item2;
        if (settings instanceof SettingsJSON) {
            settingsJSON = (SettingsJSON)item2;
        } else if (settings instanceof LicenseSettings) {
            settingsJSON = new LicenseJSON((LicenseSettings)item2);
        } else if (settings instanceof PublicSettings) {
            settingsJSON = new PublicSettingsJSON((PublicSettings)item2);
        } else if (settings instanceof InternalSettings) {
            settingsJSON = new InternalSettingsJSON((InternalSettings)item2);
        } else if (settings instanceof SMTPSettings) {
            settingsJSON = new SmtpSettingsJSON((SMTPSettings)item2);
        } else if (settings instanceof JabberSettings) {
            settingsJSON = new JabberSettingsJSON((JabberSettings)item2);
        } else if (settings instanceof BackupSettings) {
            settingsJSON = new BackupSettingsJSON((BackupSettings)item2);
        } else if (settings instanceof ImportSettings) {
            settingsJSON = new ImportSettingsJSON((ImportSettings)item2);
        } else if (settings instanceof ThrottlingSettings) {
            settingsJSON = new ThrottlingSettingsJSON((ThrottlingSettings)item2);
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown type of settings " + item2.getClass().getName());
        }
        return settingsJSON;
    }

    @Override
    @NotNull
    public SettingsJSON newJSON(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        SettingsJSON settingsJSON = new SettingsJSON();
        boolean bl = false;
        boolean bl2 = false;
        SettingsJSON $this$apply = settingsJSON;
        boolean bl3 = false;
        $this$apply.setId(id);
        return settingsJSON;
    }

    private final /* synthetic */ <S extends Settings> S getByType() {
        int $i$f$getByType = 0;
        Sequence sequence = CollectionsKt.asSequence((Iterable)this.getAllItems());
        Intrinsics.reifiedOperationMarker((int)4, (String)"S");
        return (S)((Settings)SequencesKt.first((Sequence)SequencesKt.filterIsInstance((Sequence)sequence, Settings.class)));
    }

    @Override
    @NotNull
    public PublicSettings getPublicSettings() {
        RemoteSettingsDAO this_$iv = this;
        boolean $i$f$getByType = false;
        return (PublicSettings)((Settings)SequencesKt.first((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getAllItems()), PublicSettings.class)));
    }

    @Override
    @NotNull
    public InternalSettings getInternalSettings() {
        RemoteSettingsDAO this_$iv = this;
        boolean $i$f$getByType = false;
        return (InternalSettings)((Settings)SequencesKt.first((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getAllItems()), InternalSettings.class)));
    }

    @Override
    @NotNull
    public LicenseSettings getLicenseSettings() {
        RemoteSettingsDAO this_$iv = this;
        boolean $i$f$getByType = false;
        return (LicenseSettings)((Settings)SequencesKt.first((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getAllItems()), LicenseSettings.class)));
    }

    @Override
    @NotNull
    public SMTPSettings getSMTPSettings() {
        RemoteSettingsDAO this_$iv = this;
        boolean $i$f$getByType = false;
        return (SMTPSettings)((Settings)SequencesKt.first((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getAllItems()), SMTPSettings.class)));
    }

    @Override
    @NotNull
    public JabberSettings getJabberSettings() {
        RemoteSettingsDAO this_$iv = this;
        boolean $i$f$getByType = false;
        return (JabberSettings)((Settings)SequencesKt.first((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getAllItems()), JabberSettings.class)));
    }

    @Override
    @NotNull
    public BackupSettings getBackupSettings() {
        RemoteSettingsDAO this_$iv = this;
        boolean $i$f$getByType = false;
        return (BackupSettings)((Settings)SequencesKt.first((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getAllItems()), BackupSettings.class)));
    }

    @Override
    @NotNull
    public ImportSettings getImportSettings() {
        RemoteSettingsDAO this_$iv = this;
        boolean $i$f$getByType = false;
        return (ImportSettings)((Settings)SequencesKt.first((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getAllItems()), ImportSettings.class)));
    }

    @Override
    @NotNull
    public ThrottlingSettings getThrottlingSettings() {
        RemoteSettingsDAO this_$iv = this;
        boolean $i$f$getByType = false;
        return (ThrottlingSettings)((Settings)SequencesKt.first((Sequence)SequencesKt.filterIsInstance((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getAllItems()), ThrottlingSettings.class)));
    }

    @Override
    public void testEmail(@NotNull String email) {
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        this.testSettings(this.getSMTPSettings(), email);
    }

    @Override
    public void testJabber(@NotNull String jabber) {
        Intrinsics.checkParameterIsNotNull((Object)jabber, (String)"jabber");
        this.testSettings(this.getJabberSettings(), jabber);
    }

    private final void testSettings(Settings settings, String contact) {
        SettingsJSON settingsJSON;
        String id = settings.getId();
        RemoteSettingsDAO $this$remoteRead$iv = this;
        boolean $i$f$remoteRead = false;
        try {
            boolean bl = false;
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            settingsJSON = this.client.test(string, contact, null);
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$this$remoteRead$iv.wrapClientException(ex$iv, id);
        }
        SettingsJSON result$iv = settingsJSON;
    }

    @Override
    @NotNull
    public BackupSettings.Status backup(@Nullable String targetVersion) {
        BackupStatusJSON backupStatusJSON;
        RemoteSettingsDAO $this$remoteRead$iv = this;
        String id$iv = null;
        boolean $i$f$remoteRead = false;
        try {
            boolean bl = false;
            backupStatusJSON = this.client.backupData(targetVersion, null);
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$this$remoteRead$iv.wrapClientException(ex$iv, id$iv);
        }
        BackupStatusJSON result$iv = backupStatusJSON;
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UserGroup addAutoJoinGroup(@NotNull LicenseSettings license, @NotNull UserGroup group) {
        IdItem idItem;
        void childEnd$iv$iv;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getUserGroupDAO();
        boolean $i$f$addLink = false;
        ItemRemoteRelationEnd itemRemoteRelationEnd = new ItemRemoteRelationEnd(parentDAO$iv, license);
        RemoteRelationEnd remoteRelationEnd = new ItemRemoteRelationEnd(childDAO$iv, group);
        boolean checkChildExistence$iv$iv = true;
        boolean $i$f$addChild = false;
        String parentId$iv$iv = this_$iv$iv.checkExists();
        childEnd$iv$iv.checkExists();
        Object childJSON$iv$iv = childEnd$iv$iv.toJSON();
        FieldPartial childIdPartial$iv$iv = childEnd$iv$iv.getDao().createPartial("id");
        RemoteDAO $this$remoteWrite$iv$iv$iv = this_$iv$iv.getDao();
        boolean $i$f$remoteWrite = false;
        try {
            void idPartial;
            void groupJSON;
            boolean bl = false;
            FieldPartial fieldPartial = childIdPartial$iv$iv;
            UserGroupJSON userGroupJSON = (UserGroupJSON)childJSON$iv$iv;
            String licenseId = parentId$iv$iv;
            boolean bl2 = false;
            idItem = this.client.getAutoJoinGroupsClient(licenseId).addAutoJoinGroup((UserGroupJSON)groupJSON, (FieldPartial<Partial.UserGroup>)idPartial);
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$this$remoteWrite$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        IdItem result$iv$iv$iv = idItem;
        $this$remoteWrite$iv$iv$iv.getRemoteAPI().syncNow();
        IdItem resultJSON$iv$iv = result$iv$iv$iv;
        String string = resultJSON$iv$iv.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultJSON.id");
        return (UserGroup)childEnd$iv$iv.resolve(string);
    }

    @Override
    public void removeAutoJoinGroup(@NotNull LicenseSettings license, @NotNull UserGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        this.removeAutoJoinGroup(license, group, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAutoJoinGroup(@NotNull LicenseSettings license, @NotNull UserGroup group, boolean keepUsers) {
        Unit unit;
        void this_$iv$iv;
        void parentDAO$iv;
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        RemoteDAO remoteDAO = this;
        RemoteDAO childDAO$iv = this.getRemoteAPI().getUserGroupDAO();
        boolean $i$f$removeLink = false;
        ItemRemoteRelationEnd itemRemoteRelationEnd = new ItemRemoteRelationEnd(parentDAO$iv, license);
        RemoteRelationEnd childEnd$iv$iv = new ItemRemoteRelationEnd(childDAO$iv, group);
        boolean $i$f$removeChild$jetbrains_jetpass_dao_remote = false;
        String parentId$iv$iv = this_$iv$iv.checkExists();
        String childId$iv$iv = childEnd$iv$iv.checkExists();
        RemoteDAO $this$remoteWrite$iv$iv$iv = this_$iv$iv.getDao();
        boolean $i$f$remoteWrite = false;
        try {
            void groupId;
            boolean bl = false;
            String string = childId$iv$iv;
            String licenseId = parentId$iv$iv;
            boolean bl2 = false;
            this.client.getAutoJoinGroupsClient(licenseId).removeAutoJoinGroup((String)groupId, keepUsers);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv$iv$iv) {
            throw (Throwable)$this$remoteWrite$iv$iv$iv.wrapClientException(ex$iv$iv$iv, parentId$iv$iv);
        }
        Unit result$iv$iv$iv = unit;
        $this$remoteWrite$iv$iv$iv.getRemoteAPI().syncNow();
    }

    @Override
    @NotNull
    public Settings reset(@NotNull String settingID) {
        Intrinsics.checkParameterIsNotNull((Object)settingID, (String)"settingID");
        return this.client.reset(settingID, null);
    }

    @Override
    public void sendSMTPMessage(@NotNull SMTPMessage message, boolean requireEmailVerification) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        RemoteSettingsDAO $this$remoteRead$iv = this;
        String id$iv = null;
        boolean $i$f$remoteRead = false;
        try {
            boolean bl = false;
            SmtpMessageJSON smtpMessageJSON = SmtpMessageJSON.wrap(message);
            Intrinsics.checkExpressionValueIsNotNull((Object)smtpMessageJSON, (String)"SmtpMessageJSON.wrap(message)");
            this.client.sendSMTPMessage(smtpMessageJSON, requireEmailVerification);
            unit = Unit.INSTANCE;
        }
        catch (WebApplicationException ex$iv) {
            throw (Throwable)$this$remoteRead$iv.wrapClientException(ex$iv, id$iv);
        }
        Unit result$iv = unit;
    }

    @Override
    @NotNull
    public FieldPartial<Partial.Settings> createPartial(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Partial<Partial.Settings> partial = Partial.settings(new Partial.Settings(fieldName));
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.settings(Partial.Settings(fieldName))");
        return partial;
    }

    @Override
    @NotNull
    protected Page<SettingsJSON> fetchPage(@NotNull BaseFilter<?> filter2, @NotNull FieldPartial<Partial.Settings> partial) {
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getSettingPage(filter2, partial);
    }

    @Override
    @Nullable
    protected SettingsJSON fetchItem(@NotNull String id, @NotNull FieldPartial<Partial.Settings> partial) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(partial, (String)"partial");
        return this.client.getSetting(id, partial);
    }

    @Override
    @Nullable
    public RemoteItemAccessor<Settings, SettingsJSON> getItemAccessor(@NotNull SettingsJSON dto) {
        Intrinsics.checkParameterIsNotNull((Object)dto, (String)"dto");
        return this.settingsItemAccessor.get(dto.getClass());
    }

    @Nullable
    public Void getAvailableLocales() {
        return null;
    }

    @NotNull
    public Void getUpdateStatus() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public final SettingClient getClient() {
        return this.client;
    }

    public final void setClient(@NotNull SettingClient settingClient) {
        Intrinsics.checkParameterIsNotNull((Object)settingClient, (String)"<set-?>");
        this.client = settingClient;
    }

    public RemoteSettingsDAO(@NotNull SettingClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Partial<Partial.Settings> partial = Partial.settings(Partial.Settings.ID, Partial.Settings.ALIASES(new Partial.Alias[0]));
        Intrinsics.checkExpressionValueIsNotNull(partial, (String)"Partial.settings(\n      \u2026rtial.Settings.ALIASES())");
        super((FieldPartial)partial);
        this.client = client;
        this.settingsItemAccessor = new HashMap(1);
    }
}

