/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.jetpass.dao.util.Flag;
import jetbrains.jetpass.dao.util.ObjectProcedure;
import jetbrains.jetpass.dao.util.Stack;

abstract class AbstractPersistentHashSet<K>
implements Iterable<K> {
    static final Object[] EMPTY_TABLE = new Object[0];
    static final RootTableNode EMPTY_ROOT = new RootTableNode(0, EMPTY_TABLE, 0);
    static final int BITS_PER_TABLE = 5;
    static final int BITS_IN_HASH = 32;

    AbstractPersistentHashSet() {
    }

    abstract RootTableNode<K> getRoot();

    public boolean contains(K key) {
        return this.getKey(key) != null;
    }

    public K getKey(K key) {
        return this.getRoot().getKey(key, key.hashCode(), 0);
    }

    public boolean isEmpty() {
        return this.getRoot().getMask() == 0;
    }

    public int size() {
        return this.getRoot().getSize();
    }

    @Override
    public Iterator<K> iterator() {
        return this.isEmpty() ? Collections.EMPTY_LIST.iterator() : new Iterator<K>(){
            private Stack<TreePos<K>> stack;
            private boolean hasNext;
            private boolean hasNextValid;

            @Override
            public boolean hasNext() {
                if (this.hasNextValid) {
                    return this.hasNext;
                }
                this.hasNextValid = true;
                if (this.stack == null) {
                    RootTableNode root = AbstractPersistentHashSet.this.getRoot();
                    this.stack = new Stack();
                    TreePos treePos = new TreePos(root);
                    treePos.index = -1;
                    this.stack.push(treePos);
                }
                TreePos treePos = this.stack.peek();
                treePos.index++;
                while (treePos.node.isOut(treePos.index)) {
                    this.stack.pop();
                    if (this.stack.isEmpty()) {
                        this.hasNext = false;
                        return this.hasNext;
                    }
                    treePos = this.stack.peek();
                    treePos.index++;
                }
                while (true) {
                    Object o;
                    if (!((o = treePos.node.get(treePos.index)) instanceof Node)) {
                        this.hasNext = true;
                        return this.hasNext;
                    }
                    treePos = new TreePos((Node)o);
                    this.stack.push(treePos);
                }
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextValid = false;
                TreePos treePos = this.stack.peek();
                return treePos.node.get(treePos.index);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class HashCollisionNode<K>
    implements Node<K> {
        private final K[] keys;

        HashCollisionNode(K ... keys2) {
            this.keys = keys2;
        }

        @Override
        public Node<K> insert(K key, int hash, int offset, Flag flag) {
            int keysLength = this.keys.length;
            for (int i = 0; i < keysLength; ++i) {
                if (!this.keys[i].equals(key)) continue;
                Object[] newKeys = (Object[])this.keys.clone();
                newKeys[i] = key;
                return new HashCollisionNode<Object>(newKeys);
            }
            K[] newKeys = Arrays.copyOf(this.keys, keysLength + 1);
            newKeys[keysLength] = key;
            flag.flag();
            return new HashCollisionNode<K>(newKeys);
        }

        @Override
        public Object remove(K key, int hash, int offset) {
            int keysLength = this.keys.length;
            for (int i = 0; i < keysLength; ++i) {
                if (!this.keys[i].equals(key)) continue;
                if (keysLength == 2) {
                    return this.keys[1 - i];
                }
                Object[] newKeys = new Object[keysLength - 1];
                int k = 0;
                for (int j = 0; j < keysLength; ++j) {
                    if (j == i) continue;
                    newKeys[k++] = this.keys[j];
                }
                return new HashCollisionNode<Object>(newKeys);
            }
            return null;
        }

        @Override
        public K getKey(K key, int hash, int offset) {
            for (K k : this.keys) {
                if (!k.equals(key)) continue;
                return k;
            }
            return null;
        }

        @Override
        public void checkNode(int offset) {
            int keysLength = this.keys.length;
            if (keysLength < 2) {
                throw new RuntimeException("Unnecessary hash collision node of cardinality " + keysLength);
            }
            for (K key : this.keys) {
                if (key != null) continue;
                throw new RuntimeException("Null in collision list");
            }
        }

        @Override
        public RootTableNode<K> asRoot(int size2) {
            throw new UnsupportedOperationException("Unexpected as root!");
        }

        @Override
        public Object get(int index) {
            return this.keys[index];
        }

        @Override
        public boolean isOut(int index) {
            return index + 1 > this.keys.length;
        }

        @Override
        public void forEachKey(ObjectProcedure<K> procedure) {
            for (K k : this.keys) {
                procedure.execute(k);
            }
        }
    }

    static class TableNode<K>
    implements Node<K> {
        private final int mask;
        private final Object[] table;

        TableNode(int mask, Object[] table) {
            this.mask = mask;
            this.table = table;
        }

        private TableNode(K key1, int hash1, K key2, int hash2, int offset) {
            int subhash2 = TableNode.getSubhash(hash2, offset);
            int subhash1 = TableNode.getSubhash(hash1, offset);
            if (subhash1 == subhash2) {
                this.mask = 1 << subhash1;
                this.table = new Object[]{TableNode.createNode(key1, hash1, key2, hash2, offset + 5)};
            } else {
                this.mask = (1 << subhash2) + (1 << subhash1);
                this.table = subhash1 < subhash2 ? new Object[]{key1, key2} : new Object[]{key2, key1};
            }
        }

        public int getMask() {
            return this.mask;
        }

        @Override
        public Node<K> insert(K key, int hash, int offset, Flag flag) {
            Object result;
            int subhash = TableNode.getSubhash(hash, offset);
            if ((this.mask & 1 << subhash) == 0) {
                flag.flag();
                return this.cloneAndAdd(key, subhash);
            }
            int index = this.getPosition(subhash);
            Object target = this.table[index];
            if (target instanceof Node) {
                result = ((Node)target).insert(key, hash, offset + 5, flag);
            } else if (target.equals(key)) {
                result = key;
            } else {
                flag.flag();
                result = TableNode.createNode(target, key, hash, offset + 5);
            }
            return (Node)this.cloneAndReplace(result, index, offset);
        }

        @Override
        public Object remove(K key, int hash, int offset) {
            int subhash = TableNode.getSubhash(hash, offset);
            if ((this.mask & 1 << subhash) == 0) {
                return null;
            }
            int index = this.getPosition(subhash);
            Object target = this.table[index];
            if (target instanceof Node) {
                Object removed = ((Node)target).remove(key, hash, offset + 5);
                if (removed == null) {
                    return null;
                }
                return this.cloneAndReplace(removed, index, offset);
            }
            return target.equals(key) ? this.cloneAndRemove(subhash, index, offset) : null;
        }

        @Override
        public K getKey(K key, int hash, int offset) {
            int subhash = TableNode.getSubhash(hash, offset);
            if ((this.mask & 1 << subhash) == 0) {
                return null;
            }
            int index = this.getPosition(subhash);
            Object target = this.table[index];
            if (target instanceof Node) {
                return ((Node)target).getKey(key, hash, offset + 5);
            }
            return (K)(target.equals(key) ? target : null);
        }

        @Override
        public void forEachKey(ObjectProcedure<K> procedure) {
            for (Object target : this.table) {
                if (target instanceof Node) {
                    ((Node)target).forEachKey(procedure);
                    continue;
                }
                procedure.execute(target);
            }
        }

        private TableNode<K> cloneAndAdd(K key, int subhash) {
            int index = this.getPosition(subhash);
            int tableLength = this.table.length;
            Object[] newTable = new Object[tableLength + 1];
            System.arraycopy(this.table, 0, newTable, 0, index);
            System.arraycopy(this.table, index, newTable, index + 1, tableLength - index);
            newTable[index] = key;
            return new TableNode<K>(this.mask + (1 << subhash), newTable);
        }

        private Object cloneAndReplace(Object newChild, int index, int offset) {
            int tableLength = this.table.length;
            if (offset != 0 && tableLength == 1 && !(newChild instanceof Node)) {
                return newChild;
            }
            Object[] newTable = Arrays.copyOf(this.table, tableLength);
            newTable[index] = newChild;
            return new TableNode<K>(this.mask, newTable);
        }

        private Object cloneAndRemove(int subhash, int index, int offset) {
            int size2 = this.getPosition(32);
            if (size2 == 1) {
                return new TableNode<K>(0, EMPTY_TABLE);
            }
            if (size2 == 2) {
                if (offset == 0 || this.table[1 - index] instanceof Node) {
                    return new TableNode<K>(this.mask - (1 << subhash), new Object[]{this.table[1 - index]});
                }
                return this.table[1 - index];
            }
            Object[] newTable = new Object[this.table.length - 1];
            System.arraycopy(this.table, 0, newTable, 0, index);
            System.arraycopy(this.table, index + 1, newTable, index, newTable.length - index);
            return new TableNode<K>(this.mask - (1 << subhash), newTable);
        }

        private int getPosition(int subhash) {
            int m = this.mask & (subhash == 32 ? -1 : (1 << subhash) - 1);
            m -= m >>> 1 & 0x55555555;
            m = (m & 0x33333333) + (m >>> 2 & 0x33333333);
            m = m + (m >>> 4) & 0xF0F0F0F;
            m += m >>> 8;
            return m + (m >>> 16) & 0xFF;
        }

        private static <K> Node<K> createNode(K notHashedKey, K hashedKey, int hash, int offset) {
            return TableNode.createNode(notHashedKey, notHashedKey.hashCode(), hashedKey, hash, offset);
        }

        private static <K> Node<K> createNode(K key1, int hash1, K key2, int hash2, int offset) {
            Object[] table;
            int subhash1 = TableNode.getSubhash(hash1, offset);
            int subhash2 = TableNode.getSubhash(hash2, offset);
            if (subhash2 == subhash1) {
                table = new Object[]{offset + 5 >= 32 ? new HashCollisionNode<Object>(key1, key2) : new TableNode<K>(key1, hash1, key2, hash2, offset + 5)};
            } else {
                Object[] objectArray;
                if (subhash2 < subhash1) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = key2;
                    objectArray = objectArray2;
                    objectArray2[1] = key1;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = key1;
                    objectArray = objectArray3;
                    objectArray3[1] = key2;
                }
                table = objectArray;
            }
            return new TableNode<K>(1 << subhash2 | 1 << subhash1, table);
        }

        private static int getSubhash(int hash, int offset) {
            return hash >>> offset & 0x1F;
        }

        @Override
        public void checkNode(int offset) {
            int tableLength;
            if (offset > 0 && ((tableLength = this.table.length) == 0 || tableLength == 1 && !(this.table[0] instanceof Node))) {
                throw new RuntimeException("unnecessary use of table node");
            }
            int m = this.mask;
            for (Object o : this.table) {
                if (m == 0) {
                    throw new RuntimeException("Inconsistent mask and table");
                }
                m &= m - 1;
                if (o == null) {
                    throw new RuntimeException("Null in table");
                }
                if (!(o instanceof Node)) continue;
                ((Node)o).checkNode(offset + 5);
            }
            if (m != 0) {
                throw new RuntimeException("Inconsistent mask and table");
            }
        }

        @Override
        public RootTableNode<K> asRoot(int size2) {
            return new RootTableNode(this.mask, this.table, size2);
        }

        @Override
        public Object get(int index) {
            return this.table[index];
        }

        @Override
        public boolean isOut(int index) {
            return index + 1 > this.table.length;
        }
    }

    static class RootTableNode<K>
    extends TableNode<K> {
        private final int size;

        RootTableNode(int mask, Object[] table, int size2) {
            super(mask, table);
            this.size = size2;
        }

        public int getSize() {
            return this.size;
        }
    }

    static class TreePos<K> {
        private final Node<K> node;
        private int index;

        TreePos(Node<K> node) {
            this.node = node;
            this.index = 0;
        }
    }

    static interface Node<K> {
        public Node<K> insert(K var1, int var2, int var3, Flag var4);

        public Object remove(K var1, int var2, int var3);

        public K getKey(K var1, int var2, int var3);

        public void checkNode(int var1);

        public RootTableNode<K> asRoot(int var1);

        public Object get(int var1);

        public boolean isOut(int var1);

        public void forEachKey(ObjectProcedure<K> var1);
    }
}

