/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.access.SourcedProjectRole;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.SourcedProjectRoleJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="authorityHolder")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=AuthorityHolderJSON.class)
public class AuthorityHolderJSON
implements AuthorityHolder {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="projectRoles")
    private List<ProjectRoleJSON> projectRoles;
    @XmlElement(name="transitiveProjectRoles")
    private List<ProjectRoleJSON> transitiveProjectRoles;
    @XmlElement(name="sourcedProjectRoles")
    private List<SourcedProjectRoleJSON> sourcedProjectRoles;

    public AuthorityHolderJSON() {
    }

    public AuthorityHolderJSON(@NotNull AuthorityHolder that) {
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        if (that.getSourcedProjectRoles() != null) {
            aggregated = new ArrayList();
            for (SourcedProjectRole sourcedProjectRole : that.getSourcedProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new SourcedProjectRoleJSON(sourcedProjectRole)));
            }
            this.setSourcedProjectRoles(aggregated);
        }
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Iterable<ProjectRoleJSON> getProjectRoles() {
        return this.projectRoles;
    }

    @Nullable
    public Iterable<ProjectRoleJSON> getTransitiveProjectRoles() {
        return this.transitiveProjectRoles;
    }

    @Nullable
    public Iterable<SourcedProjectRoleJSON> getSourcedProjectRoles() {
        return this.sourcedProjectRoles;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setProjectRoles(@Nullable Iterable<ProjectRoleJSON> projectRoles2) {
        this.projectRoles = JsonUtils.iterableToList(projectRoles2);
    }

    @XmlTransient
    public void setTransitiveProjectRoles(@Nullable Iterable<ProjectRoleJSON> transitiveProjectRoles) {
        this.transitiveProjectRoles = JsonUtils.iterableToList(transitiveProjectRoles);
    }

    @XmlTransient
    public void setSourcedProjectRoles(@Nullable Iterable<SourcedProjectRoleJSON> sourcedProjectRoles) {
        this.sourcedProjectRoles = JsonUtils.iterableToList(sourcedProjectRoles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorityHolder)) {
            return false;
        }
        AuthorityHolder that = (AuthorityHolder)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static AuthorityHolderJSON wrap(@NotNull AuthorityHolder that) {
        if (that instanceof AuthorityHolderJSON) {
            return (AuthorityHolderJSON)that;
        }
        return new AuthorityHolderJSON(that);
    }
}

