/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.BackupSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.BackupStatusJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="backupSettings")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=BackupSettingsJSON.class)
public class BackupSettingsJSON
extends SettingsJSON
implements BackupSettings {
    @XmlElement(name="namePrefix")
    private String namePrefix;
    @XmlElement(name="backupFolder")
    private String backupFolder;
    @XmlElement(name="resolvedBackupFolder")
    private String resolvedBackupFolder;
    @XmlElement(name="archiveType")
    private String archiveType;
    @XmlElement(name="status")
    private BackupStatusJSON status;
    @XmlElement(name="databaseReadonly")
    private Boolean databaseReadonly;
    @XmlElement(name="cronExpression")
    private String cronExpression;
    @XmlElement(name="countToKeep")
    private Integer countToKeep;

    public BackupSettingsJSON() {
    }

    public BackupSettingsJSON(@NotNull BackupSettings that) {
        this.setId(that.getId());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setNamePrefix(that.getNamePrefix());
        this.setBackupFolder(that.getBackupFolder());
        this.setResolvedBackupFolder(that.getResolvedBackupFolder());
        this.setArchiveType(that.getArchiveType());
        if (that.getStatus() != null) {
            this.setStatus(new BackupStatusJSON(that.getStatus()));
        }
        this.setDatabaseReadonly(that.isDatabaseReadonly());
        this.setCronExpression(that.getCronExpression());
        this.setCountToKeep(that.getCountToKeep());
    }

    @Override
    @Nullable
    public String getNamePrefix() {
        return this.namePrefix;
    }

    @Override
    @Nullable
    public String getBackupFolder() {
        return this.backupFolder;
    }

    @Override
    @Nullable
    public String getResolvedBackupFolder() {
        return this.resolvedBackupFolder;
    }

    @Override
    @Nullable
    public String getArchiveType() {
        return this.archiveType;
    }

    @Override
    @Nullable
    public BackupStatusJSON getStatus() {
        return this.status;
    }

    @Override
    @Nullable
    public Boolean isDatabaseReadonly() {
        return this.databaseReadonly;
    }

    @Override
    @Nullable
    public String getCronExpression() {
        return this.cronExpression;
    }

    @Override
    @Nullable
    public Integer getCountToKeep() {
        return this.countToKeep;
    }

    @XmlTransient
    public void setNamePrefix(@Nullable String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @XmlTransient
    public void setBackupFolder(@Nullable String backupFolder) {
        this.backupFolder = backupFolder;
    }

    @XmlTransient
    public void setResolvedBackupFolder(@Nullable String resolvedBackupFolder) {
        this.resolvedBackupFolder = resolvedBackupFolder;
    }

    @XmlTransient
    public void setArchiveType(@Nullable String archiveType) {
        this.archiveType = archiveType;
    }

    @XmlTransient
    public void setStatus(@Nullable BackupStatusJSON status) {
        this.status = status;
    }

    @XmlTransient
    public void setDatabaseReadonly(@Nullable Boolean databaseReadonly) {
        this.databaseReadonly = databaseReadonly;
    }

    @XmlTransient
    public void setCronExpression(@Nullable String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @XmlTransient
    public void setCountToKeep(@Nullable Integer countToKeep) {
        this.countToKeep = countToKeep;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupSettings)) {
            return false;
        }
        BackupSettings that = (BackupSettings)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static BackupSettingsJSON wrap(@NotNull BackupSettings that) {
        if (that instanceof BackupSettingsJSON) {
            return (BackupSettingsJSON)that;
        }
        return new BackupSettingsJSON(that);
    }
}

