/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.ssl.Certificate;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.FingerprintJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="certificate")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CertificateJSON
implements Certificate {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="disabled")
    private Boolean disabled;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="data")
    private String data;
    @XmlElement(name="certificateType")
    private String certificateType;
    @XmlElement(name="version")
    private Integer version;
    @XmlElement(name="serialNumber")
    private String serialNumber;
    @XmlElement(name="issuedBy")
    private String issuedBy;
    @XmlElement(name="issuedTo")
    private String issuedTo;
    @XmlElement(name="validFrom")
    private Calendar validFrom;
    @XmlElement(name="validTo")
    private Calendar validTo;
    @XmlElement(name="algorithm")
    private String algorithm;
    @XmlElement(name="fingerprint")
    private FingerprintJSON fingerprint;

    public CertificateJSON() {
    }

    public CertificateJSON(@NotNull Certificate that) {
        this.setId(that.getId());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setDisabled(that.isDisabled());
        this.setName(that.getName());
        this.setData(that.getData());
        this.setCertificateType(that.getCertificateType());
        this.setVersion(that.getVersion());
        this.setSerialNumber(that.getSerialNumber());
        this.setIssuedBy(that.getIssuedBy());
        this.setIssuedTo(that.getIssuedTo());
        this.setValidFrom(that.getValidFrom());
        this.setValidTo(that.getValidTo());
        this.setAlgorithm(that.getAlgorithm());
        if (that.getFingerprint() != null) {
            this.setFingerprint(new FingerprintJSON(that.getFingerprint()));
        }
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public Boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getData() {
        return this.data;
    }

    @Override
    @Nullable
    public String getCertificateType() {
        return this.certificateType;
    }

    @Override
    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    @Nullable
    public String getIssuedBy() {
        return this.issuedBy;
    }

    @Override
    @Nullable
    public String getIssuedTo() {
        return this.issuedTo;
    }

    @Override
    @Nullable
    public Calendar getValidFrom() {
        return this.validFrom;
    }

    @Override
    @Nullable
    public Calendar getValidTo() {
        return this.validTo;
    }

    @Override
    @Nullable
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @Nullable
    public FingerprintJSON getFingerprint() {
        return this.fingerprint;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setDisabled(@Nullable Boolean disabled) {
        this.disabled = disabled;
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setData(@Nullable String data) {
        this.data = data;
    }

    @XmlTransient
    public void setCertificateType(@Nullable String certificateType) {
        this.certificateType = certificateType;
    }

    @XmlTransient
    public void setVersion(@Nullable Integer version) {
        this.version = version;
    }

    @XmlTransient
    public void setSerialNumber(@Nullable String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @XmlTransient
    public void setIssuedBy(@Nullable String issuedBy) {
        this.issuedBy = issuedBy;
    }

    @XmlTransient
    public void setIssuedTo(@Nullable String issuedTo) {
        this.issuedTo = issuedTo;
    }

    @XmlTransient
    public void setValidFrom(@Nullable Calendar validFrom) {
        this.validFrom = validFrom;
    }

    @XmlTransient
    public void setValidTo(@Nullable Calendar validTo) {
        this.validTo = validTo;
    }

    @XmlTransient
    public void setAlgorithm(@Nullable String algorithm) {
        this.algorithm = algorithm;
    }

    @XmlTransient
    public void setFingerprint(@Nullable FingerprintJSON fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate that = (Certificate)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static CertificateJSON wrap(@NotNull Certificate that) {
        if (that instanceof CertificateJSON) {
            return (CertificateJSON)that;
        }
        return new CertificateJSON(that);
    }
}

