/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.NamedItem;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.EmailJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="details")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=DetailsJSON.class)
public class DetailsJSON
implements UserDetails {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="email")
    private EmailJSON email;
    @XmlElement(name="authModule")
    private AuthmoduleJSON authModule;
    @XmlElement(name="authModuleName")
    private String authModuleName;
    @XmlElement(name="user")
    private UserJSON user;
    @XmlElement(name="lastAccessTime")
    private Calendar lastAccessTime;
    @XmlElement(name="lastAccessAddress")
    private String lastAccessAddress;
    @XmlElement(name="lastAccessUserAgent")
    private String lastAccessUserAgent;

    public DetailsJSON() {
    }

    public DetailsJSON(@NotNull UserDetails that) {
        NamedItem ref;
        this.setId(that.getId());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        if (that.getEmail() != null) {
            this.setEmail(new EmailJSON(that.getEmail()));
        }
        if (that.getAuthModule() != null) {
            ref = new AuthmoduleJSON();
            ((AuthmoduleJSON)ref).setId(that.getAuthModule().getId());
            this.setAuthModule((AuthmoduleJSON)ref);
        }
        this.setAuthModuleName(that.getAuthModuleName());
        if (that.getUser() != null) {
            ref = new UserJSON();
            ((AuthorityHolderJSON)ref).setId(that.getUser().getId());
            this.setUser((UserJSON)ref);
        }
        this.setLastAccessTime(that.getLastAccessTime());
        this.setLastAccessAddress(that.getLastAccessAddress());
        this.setLastAccessUserAgent(that.getLastAccessUserAgent());
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public EmailJSON getEmail() {
        return this.email;
    }

    @Override
    @Nullable
    public AuthmoduleJSON getAuthModule() {
        return this.authModule;
    }

    @Override
    @Nullable
    public String getAuthModuleName() {
        return this.authModuleName;
    }

    @Override
    @Nullable
    public UserJSON getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public Calendar getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    @Nullable
    public String getLastAccessAddress() {
        return this.lastAccessAddress;
    }

    @Override
    @Nullable
    public String getLastAccessUserAgent() {
        return this.lastAccessUserAgent;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setEmail(@Nullable EmailJSON email) {
        this.email = email;
    }

    @XmlTransient
    public void setAuthModule(@Nullable AuthmoduleJSON authModule) {
        this.authModule = authModule;
    }

    @XmlTransient
    public void setAuthModuleName(@Nullable String authModuleName) {
        this.authModuleName = authModuleName;
    }

    @XmlTransient
    public void setUser(@Nullable UserJSON user) {
        this.user = user;
    }

    @XmlTransient
    public void setLastAccessTime(@Nullable Calendar lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @XmlTransient
    public void setLastAccessAddress(@Nullable String lastAccessAddress) {
        this.lastAccessAddress = lastAccessAddress;
    }

    @XmlTransient
    public void setLastAccessUserAgent(@Nullable String lastAccessUserAgent) {
        this.lastAccessUserAgent = lastAccessUserAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserDetails)) {
            return false;
        }
        UserDetails that = (UserDetails)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static DetailsJSON wrap(@NotNull UserDetails that) {
        if (that instanceof DetailsJSON) {
            return (DetailsJSON)that;
        }
        return new DetailsJSON(that);
    }
}

