/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.event.LinkChange;
import jetbrains.jetpass.api.event.LinkData;
import jetbrains.jetpass.rest.dto.ChangeJSON;
import jetbrains.jetpass.rest.dto.LinkDataJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="linkChange")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=LinkChangeJSON.class)
public class LinkChangeJSON
extends ChangeJSON
implements LinkChange {
    @XmlElement(name="removed")
    private List<LinkDataJSON> removed;
    @XmlElement(name="added")
    private List<LinkDataJSON> added;

    public LinkChangeJSON() {
    }

    public LinkChangeJSON(@NotNull LinkChange that) {
        ArrayList<LinkDataJSON> aggregated;
        this.setFieldName(that.getFieldName());
        this.setFieldType(that.getFieldType());
        if (that.getRemoved() != null) {
            aggregated = new ArrayList<LinkDataJSON>();
            for (LinkData linkData : that.getRemoved()) {
                aggregated.add(new LinkDataJSON(linkData));
            }
            this.setRemoved(aggregated);
        }
        if (that.getAdded() != null) {
            aggregated = new ArrayList();
            for (LinkData linkData : that.getAdded()) {
                aggregated.add(new LinkDataJSON(linkData));
            }
            this.setAdded(aggregated);
        }
    }

    @Nullable
    public Iterable<LinkDataJSON> getRemoved() {
        return this.removed;
    }

    @Nullable
    public Iterable<LinkDataJSON> getAdded() {
        return this.added;
    }

    @XmlTransient
    public void setRemoved(@Nullable Iterable<LinkDataJSON> removed) {
        this.removed = JsonUtils.iterableToList(removed);
    }

    @XmlTransient
    public void setAdded(@Nullable Iterable<LinkDataJSON> added) {
        this.added = JsonUtils.iterableToList(added);
    }

    @NotNull
    public static LinkChangeJSON wrap(@NotNull LinkChange that) {
        if (that instanceof LinkChangeJSON) {
            return (LinkChangeJSON)that;
        }
        return new LinkChangeJSON(that);
    }
}

