/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Organization;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="organization")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OrganizationJSON
implements Organization {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="key")
    private String key;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="creationTime")
    private Calendar creationTime;
    @XmlElement(name="projects")
    private List<ProjectJSON> projects;
    @XmlElement(name="users")
    private List<UserJSON> users;
    @XmlElement(name="groups")
    private List<UserGroupJSON> groups;
    @XmlElement(name="teams")
    private List<ProjectTeamJSON> teams;
    @XmlElement(name="projectsCount")
    private Integer projectsCount;
    @XmlElement(name="iconUrl")
    private String iconUrl;
    @XmlElement(name="icon")
    private String icon;
    @XmlElement(name="defaultIcon")
    private Boolean defaultIcon;

    public OrganizationJSON() {
    }

    public OrganizationJSON(@NotNull Organization that) {
        this.setId(that.getId());
        this.setKey(that.getKey());
        this.setName(that.getName());
        this.setDescription(that.getDescription());
        this.setCreationTime(that.getCreationTime());
        if (that.getProjects() != null) {
            ArrayList<ProjectJSON> projectJSONs = new ArrayList<ProjectJSON>();
            for (Project project : that.getProjects()) {
                projectJSONs.add(ProjectJSON.wrap(project));
            }
            projectJSONs.sort(Comparator.comparing(ProjectJSON::getName));
            this.setProjects(projectJSONs);
        }
        if (that.getUsers() != null) {
            ArrayList<UserJSON> users = new ArrayList<UserJSON>();
            for (User user : that.getUsers()) {
                UserJSON user2 = new UserJSON();
                user2.setId(user.getId());
                users.add(user2);
            }
            this.setUsers(users);
        }
        if (that.getGroups() != null) {
            ArrayList<UserGroupJSON> groups2 = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getGroups()) {
                UserGroupJSON group = new UserGroupJSON();
                group.setId(userGroup.getId());
                groups2.add(group);
            }
            this.setGroups(groups2);
        }
        this.setProjectsCount(that.getProjectsCount());
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    public Iterable<? extends Alias> getAliases() {
        return null;
    }

    @Override
    @Nullable
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public Calendar getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Nullable
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public Iterable<? extends User> getUsers() {
        return this.users;
    }

    @Override
    @Nullable
    public Iterable<? extends UserGroup> getGroups() {
        return this.groups;
    }

    @Override
    public Iterable<? extends ProjectTeam> getTeams() {
        return this.teams;
    }

    @Override
    @Nullable
    public Boolean isDefaultIcon() {
        return this.defaultIcon;
    }

    @XmlTransient
    public void setCreationTime(@Nullable Calendar creationTime) {
        this.creationTime = creationTime;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setKey(@Nullable String key) {
        this.key = key;
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nullable
    public Iterable<ProjectJSON> getProjects() {
        return this.projects;
    }

    @XmlTransient
    public void setProjects(@Nullable Iterable<ProjectJSON> projects) {
        this.projects = JsonUtils.iterableToList(projects);
    }

    @XmlTransient
    public void setUsers(@Nullable Iterable<UserJSON> users) {
        this.users = JsonUtils.iterableToList(users);
    }

    @XmlTransient
    public void setGroups(@Nullable Iterable<UserGroupJSON> groups2) {
        this.groups = JsonUtils.iterableToList(groups2);
    }

    @XmlTransient
    public void setTeams(@Nullable Iterable<ProjectTeamJSON> teams) {
        this.teams = JsonUtils.iterableToList(teams);
    }

    @Override
    @Nullable
    public Integer getProjectsCount() {
        return this.projectsCount;
    }

    @XmlTransient
    public void setProjectsCount(@Nullable Integer projectsCount) {
        this.projectsCount = projectsCount;
    }

    @XmlTransient
    public void setIconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @XmlTransient
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @XmlTransient
    public void setDefaultIcon(@Nullable Boolean defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project that = (Project)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static OrganizationJSON wrap(@NotNull Organization that) {
        if (that instanceof OrganizationJSON) {
            return (OrganizationJSON)that;
        }
        return new OrganizationJSON(that);
    }
}

