/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.auth.PermanentToken;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="permanentToken")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PermanentTokenJSON
implements PermanentToken {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="token")
    private String token;
    @XmlElement(name="scope")
    private List<ServiceJSON> scope;
    @XmlElement(name="user")
    private UserJSON user;
    @XmlElement(name="author")
    private UserJSON author;
    @XmlElement(name="creationTime")
    private Calendar creationTime;
    @XmlElement(name="lastAccessTime")
    private Calendar lastAccessTime;

    public PermanentTokenJSON() {
    }

    public PermanentTokenJSON(@NotNull PermanentToken that) {
        UserJSON ref;
        this.setId(that.getId());
        this.setName(that.getName());
        this.setToken(that.getToken());
        if (that.getScope() != null) {
            ArrayList<ServiceJSON> references = new ArrayList<ServiceJSON>();
            for (Service service2 : that.getScope()) {
                ServiceJSON ref2 = new ServiceJSON();
                ref2.setId(service2.getId());
                references.add(ref2);
            }
            this.setScope(references);
        }
        if (that.getUser() != null) {
            ref = new UserJSON();
            ref.setId(that.getUser().getId());
            this.setUser(ref);
        }
        if (that.getAuthor() != null) {
            ref = new UserJSON();
            ref.setId(that.getAuthor().getId());
            this.setAuthor(ref);
        }
        this.setCreationTime(that.getCreationTime());
        this.setLastAccessTime(that.getLastAccessTime());
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Nullable
    public Iterable<ServiceJSON> getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public UserJSON getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public UserJSON getAuthor() {
        return this.author;
    }

    @Override
    @Nullable
    public Calendar getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Nullable
    public Calendar getLastAccessTime() {
        return this.lastAccessTime;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setToken(@Nullable String token) {
        this.token = token;
    }

    @XmlTransient
    public void setScope(@Nullable Iterable<ServiceJSON> scope2) {
        this.scope = JsonUtils.iterableToList(scope2);
    }

    @XmlTransient
    public void setUser(@Nullable UserJSON user) {
        this.user = user;
    }

    @XmlTransient
    public void setAuthor(@Nullable UserJSON author) {
        this.author = author;
    }

    @XmlTransient
    public void setCreationTime(@Nullable Calendar creationTime) {
        this.creationTime = creationTime;
    }

    @XmlTransient
    public void setLastAccessTime(@Nullable Calendar lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @NotNull
    public static PermanentTokenJSON wrap(@NotNull PermanentToken that) {
        if (that instanceof PermanentTokenJSON) {
            return (PermanentTokenJSON)that;
        }
        return new PermanentTokenJSON(that);
    }
}

