/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.NamedItem;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.OrganizationJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="project")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProjectJSON
implements Project {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="key")
    private String key;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="archived")
    private Boolean archived;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="creationTime")
    private Calendar creationTime;
    @XmlElement(name="iconUrl")
    private String iconUrl;
    @XmlElement(name="icon")
    private String icon;
    @XmlElement(name="defaultIcon")
    private Boolean defaultIcon;
    @XmlElement(name="resources")
    private List<ResourceJSON> resources;
    @XmlElement(name="projectRoles")
    private List<ProjectRoleJSON> projectRoles;
    @XmlElement(name="transitiveProjectRoles")
    private List<ProjectRoleJSON> transitiveProjectRoles;
    @XmlElement(name="myFavorite")
    private Boolean myFavorite;
    @XmlElement(name="team")
    private ProjectTeamJSON team;
    @XmlElement(name="owner")
    private UserJSON owner;
    @XmlElement(name="global")
    private Boolean global;
    @XmlElement(name="dashboard")
    @JsonRawValue
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dashboard;
    @XmlElement(name="organization")
    private OrganizationJSON organization;

    public ProjectJSON() {
    }

    public ProjectJSON(@NotNull Project that) {
        NamedItem ref;
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setKey(that.getKey());
        this.setName(that.getName());
        this.setArchived(that.isArchived());
        this.setDescription(that.getDescription());
        this.setCreationTime(that.getCreationTime());
        this.setIconUrl(that.getIconUrl());
        this.setIcon(that.getIcon());
        this.setDefaultIcon(that.isDefaultIcon());
        if (that.getResources() != null) {
            ArrayList<ResourceJSON> references = new ArrayList<ResourceJSON>();
            for (Resource resource : that.getResources()) {
                ResourceJSON ref2 = new ResourceJSON();
                ref2.setId(resource.getId());
                references.add(ref2);
            }
            this.setResources(references);
        }
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        this.setMyFavorite(that.isMyFavorite());
        if (that.getTeam() != null) {
            ref = new ProjectTeamJSON();
            ((AuthorityHolderJSON)ref).setId(that.getTeam().getId());
            this.setTeam((ProjectTeamJSON)ref);
        }
        if (that.getOwner() != null) {
            ref = new UserJSON();
            ((AuthorityHolderJSON)ref).setId(that.getOwner().getId());
            this.setOwner((UserJSON)ref);
        }
        if (that.getOrganization() != null) {
            ref = new OrganizationJSON();
            ((OrganizationJSON)ref).setId(that.getOrganization().getId());
            this.setOrganization((OrganizationJSON)ref);
        }
        this.setGlobal(that.isGlobal());
        this.setDashboard(that.getDashboard());
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean isArchived() {
        return this.archived;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public Calendar getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Nullable
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public Boolean isDefaultIcon() {
        return this.defaultIcon;
    }

    @Nullable
    public Iterable<ResourceJSON> getResources() {
        return this.resources;
    }

    @Nullable
    public Iterable<ProjectRoleJSON> getProjectRoles() {
        return this.projectRoles;
    }

    @Nullable
    public Iterable<ProjectRoleJSON> getTransitiveProjectRoles() {
        return this.transitiveProjectRoles;
    }

    @Override
    @Nullable
    public Boolean isMyFavorite() {
        return this.myFavorite;
    }

    @Override
    @Nullable
    public ProjectTeamJSON getTeam() {
        return this.team;
    }

    @Override
    @Nullable
    public UserJSON getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public Boolean isGlobal() {
        return this.global;
    }

    @Override
    public String getDashboard() {
        return this.dashboard;
    }

    @Override
    @Nullable
    public OrganizationJSON getOrganization() {
        return this.organization;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setKey(@Nullable String key) {
        this.key = key;
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setArchived(@Nullable Boolean archived) {
        this.archived = archived;
    }

    @XmlTransient
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @XmlTransient
    public void setCreationTime(@Nullable Calendar creationTime) {
        this.creationTime = creationTime;
    }

    @XmlTransient
    public void setIconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @XmlTransient
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @XmlTransient
    public void setDefaultIcon(@Nullable Boolean defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @XmlTransient
    public void setResources(@Nullable Iterable<ResourceJSON> resources) {
        this.resources = JsonUtils.iterableToList(resources);
    }

    @XmlTransient
    public void setProjectRoles(@Nullable Iterable<ProjectRoleJSON> projectRoles2) {
        this.projectRoles = JsonUtils.iterableToList(projectRoles2);
    }

    @XmlTransient
    public void setTransitiveProjectRoles(@Nullable Iterable<ProjectRoleJSON> transitiveProjectRoles) {
        this.transitiveProjectRoles = JsonUtils.iterableToList(transitiveProjectRoles);
    }

    @XmlTransient
    public void setMyFavorite(@Nullable Boolean myFavorite) {
        this.myFavorite = myFavorite;
    }

    @XmlTransient
    public void setTeam(@Nullable ProjectTeamJSON team) {
        this.team = team;
    }

    @XmlTransient
    public void setOwner(@Nullable UserJSON owner) {
        this.owner = owner;
    }

    @XmlTransient
    public void setGlobal(@Nullable Boolean global) {
        this.global = global;
    }

    @JsonProperty
    public void setDashboard(@Nullable JsonNode dashboardJson) {
        this.dashboard = dashboardJson != null ? dashboardJson.toString() : "{}";
    }

    @XmlTransient
    public void setDashboard(String dashboard) {
        this.dashboard = dashboard;
    }

    @XmlTransient
    public void setOrganization(@Nullable OrganizationJSON organization) {
        this.organization = organization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project that = (Project)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ProjectJSON wrap(@NotNull Project that) {
        if (that instanceof ProjectJSON) {
            return (ProjectJSON)that;
        }
        return new ProjectJSON(that);
    }
}

