/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.NamedItem;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="projectRole")
@XmlRootElement(name="projectRole")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ProjectRoleJSON.class)
public class ProjectRoleJSON
implements ProjectRole {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="role")
    private RoleJSON role;
    @XmlElement(name="project")
    private ProjectJSON project;
    @XmlElement(name="owner")
    private AuthorityHolderJSON owner;
    @XmlElement(name="teamMember")
    private Boolean teamMember;

    public ProjectRoleJSON() {
    }

    public ProjectRoleJSON(@NotNull ProjectRole that) {
        NamedItem ref;
        this.setId(that.getId());
        this.setTeamMember(that.isTeamMember());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        if (that.getRole() != null) {
            ref = new RoleJSON();
            ((RoleJSON)ref).setId(that.getRole().getId());
            this.setRole((RoleJSON)ref);
        }
        if (that.getProject() != null) {
            ref = new ProjectJSON();
            ((ProjectJSON)ref).setId(that.getProject().getId());
            this.setProject((ProjectJSON)ref);
        }
        if (that.getOwner() != null) {
            ref = new AuthorityHolderJSON();
            ((AuthorityHolderJSON)ref).setId(that.getOwner().getId());
            this.setOwner((AuthorityHolderJSON)ref);
        }
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public RoleJSON getRole() {
        return this.role;
    }

    @Override
    @Nullable
    public ProjectJSON getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public AuthorityHolderJSON getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public Boolean isTeamMember() {
        return this.teamMember;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setRole(@Nullable RoleJSON role) {
        this.role = role;
    }

    @XmlTransient
    public void setProject(@Nullable ProjectJSON project) {
        this.project = project;
    }

    @XmlTransient
    public void setOwner(@Nullable AuthorityHolderJSON owner) {
        this.owner = owner;
    }

    @XmlTransient
    public void setTeamMember(Boolean teamMember) {
        this.teamMember = teamMember;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectRole)) {
            return false;
        }
        ProjectRole that = (ProjectRole)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ProjectRoleJSON wrap(@NotNull ProjectRole that) {
        if (that instanceof ProjectRoleJSON) {
            return (ProjectRoleJSON)that;
        }
        return new ProjectRoleJSON(that);
    }
}

