/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.dashboard.ProjectTeamDashboardPermission;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.DashboardPermissionJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="projectTeamDashboardPermission")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ProjectTeamDashboardPermissionJSON.class)
public class ProjectTeamDashboardPermissionJSON
extends DashboardPermissionJSON
implements ProjectTeamDashboardPermission {
    @XmlElement(name="projectTeam")
    private ProjectTeamJSON projectTeam;

    public ProjectTeamDashboardPermissionJSON() {
    }

    public ProjectTeamDashboardPermissionJSON(@NotNull ProjectTeamDashboardPermission that) {
        this.setId(that.getId());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setPermission(that.getPermission());
        if (that.getProjectTeam() != null) {
            ProjectTeamJSON ref = new ProjectTeamJSON();
            ref.setId(that.getProjectTeam().getId());
            this.setProjectTeam(ref);
        }
    }

    @Override
    @Nullable
    public ProjectTeamJSON getProjectTeam() {
        return this.projectTeam;
    }

    @XmlTransient
    public void setProjectTeam(@Nullable ProjectTeamJSON projectTeam) {
        this.projectTeam = projectTeam;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectTeamDashboardPermission)) {
            return false;
        }
        ProjectTeamDashboardPermission that = (ProjectTeamDashboardPermission)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ProjectTeamDashboardPermissionJSON wrap(@NotNull ProjectTeamDashboardPermission that) {
        if (that instanceof ProjectTeamDashboardPermissionJSON) {
            return (ProjectTeamDashboardPermissionJSON)that;
        }
        return new ProjectTeamDashboardPermissionJSON(that);
    }
}

