/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Organization;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.OrganizationJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="projectTeam")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ProjectTeamJSON.class)
@JsonTypeName(value="projectTeam")
public class ProjectTeamJSON
extends AuthorityHolderJSON
implements ProjectTeam {
    @XmlElement(name="groups")
    private List<UserGroupJSON> groups;
    @XmlElement(name="users")
    private List<UserJSON> users;
    @XmlElement(name="ownUsers")
    private List<UserJSON> ownUsers;
    @XmlElement(name="project")
    private ProjectJSON project;
    @XmlElement(name="userCount")
    private Integer userCount;
    @XmlElement(name="organizations")
    private List<OrganizationJSON> organizations;

    public ProjectTeamJSON() {
    }

    public ProjectTeamJSON(@NotNull ProjectTeam that) {
        AuthorityHolderJSON ref;
        ArrayList<UserGroupJSON> references;
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        if (that.getGroups() != null) {
            references = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getGroups()) {
                ref = new UserGroupJSON();
                ref.setId(userGroup.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setGroups(references);
        }
        if (that.getUsers() != null) {
            references = new ArrayList();
            for (User user : that.getUsers()) {
                ref = new UserJSON();
                ref.setId(user.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setUsers(references);
        }
        if (that.getOwnUsers() != null) {
            references = new ArrayList();
            for (User user : that.getOwnUsers()) {
                ref = new UserJSON();
                ref.setId(user.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setOwnUsers(references);
        }
        if (that.getProject() != null) {
            ProjectJSON ref2 = new ProjectJSON();
            ref2.setId(that.getProject().getId());
            this.setProject(ref2);
        }
        if (that.getOrganizations() != null) {
            ArrayList<OrganizationJSON> orgs = new ArrayList<OrganizationJSON>();
            for (Organization organization : that.getOrganizations()) {
                OrganizationJSON org = new OrganizationJSON();
                org.setId(organization.getId());
                orgs.add(org);
            }
            this.setOrganizations(orgs);
        }
        this.setUserCount(that.getUserCount());
    }

    @Nullable
    public Iterable<UserGroupJSON> getGroups() {
        return this.groups;
    }

    @Nullable
    public Iterable<UserJSON> getUsers() {
        return this.users;
    }

    @Nullable
    public Iterable<UserJSON> getOwnUsers() {
        return this.ownUsers;
    }

    @Override
    @Nullable
    public ProjectJSON getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public Integer getUserCount() {
        return this.userCount;
    }

    @Override
    public Iterable<? extends Organization> getOrganizations() {
        return this.organizations;
    }

    public void setOrganizations(@Nullable Iterable<OrganizationJSON> organizations) {
        this.organizations = JsonUtils.iterableToList(organizations);
    }

    @XmlTransient
    public void setGroups(@Nullable Iterable<UserGroupJSON> groups2) {
        this.groups = JsonUtils.iterableToList(groups2);
    }

    @XmlTransient
    public void setUsers(@Nullable Iterable<UserJSON> users) {
        this.users = JsonUtils.iterableToList(users);
    }

    @XmlTransient
    public void setOwnUsers(@Nullable Iterable<UserJSON> ownUsers) {
        this.ownUsers = JsonUtils.iterableToList(ownUsers);
    }

    @XmlTransient
    public void setProject(@Nullable ProjectJSON project) {
        this.project = project;
    }

    @XmlTransient
    public void setUserCount(@Nullable Integer userCount) {
        this.userCount = userCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectTeam)) {
            return false;
        }
        ProjectTeam that = (ProjectTeam)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ProjectTeamJSON wrap(@NotNull ProjectTeam that) {
        if (that instanceof ProjectTeamJSON) {
            return (ProjectTeamJSON)that;
        }
        return new ProjectTeamJSON(that);
    }
}

