/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.NamedItem;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="resource")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResourceJSON
implements Resource {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="key")
    private String key;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="homeUrl")
    private String homeUrl;
    @XmlElement(name="type")
    private String type;
    @XmlElement(name="service")
    private ServiceJSON service;
    @XmlElement(name="project")
    private ProjectJSON project;

    public ResourceJSON() {
    }

    public ResourceJSON(@NotNull Resource that) {
        NamedItem ref;
        this.setId(that.getId());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setKey(that.getKey());
        this.setName(that.getName());
        this.setHomeUrl(that.getHomeUrl());
        this.setType(that.getType());
        if (that.getService() != null) {
            ref = new ServiceJSON();
            ((AuthorityHolderJSON)ref).setId(that.getService().getId());
            this.setService((ServiceJSON)ref);
        }
        if (that.getProject() != null) {
            ref = new ProjectJSON();
            ((ProjectJSON)ref).setId(that.getProject().getId());
            this.setProject((ProjectJSON)ref);
        }
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getHomeUrl() {
        return this.homeUrl;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public ServiceJSON getService() {
        return this.service;
    }

    @Override
    @Nullable
    public ProjectJSON getProject() {
        return this.project;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setKey(@Nullable String key) {
        this.key = key;
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setHomeUrl(@Nullable String homeUrl) {
        this.homeUrl = homeUrl;
    }

    @XmlTransient
    public void setType(@Nullable String type) {
        this.type = type;
    }

    @XmlTransient
    public void setService(@Nullable ServiceJSON service2) {
        this.service = service2;
    }

    @XmlTransient
    public void setProject(@Nullable ProjectJSON project) {
        this.project = project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource that = (Resource)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ResourceJSON wrap(@NotNull Resource that) {
        if (that instanceof ResourceJSON) {
            return (ResourceJSON)that;
        }
        return new ResourceJSON(that);
    }
}

