/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.feature.ScopedFeature;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.HubFeatureJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="scopedFeature")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ScopedFeatureJSON.class)
public class ScopedFeatureJSON
extends HubFeatureJSON
implements ScopedFeature {
    @XmlElement(name="scopes")
    private List<AuthorityHolderJSON> scopes;

    public ScopedFeatureJSON() {
    }

    public ScopedFeatureJSON(@NotNull ScopedFeature that) {
        this.setId(that.getId());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setKey(that.getKey());
        this.setName(that.getName());
        this.setDescription(that.getDescription());
        this.setRestartRequired(that.isRestartRequired());
        this.setEnabled(that.isEnabled());
        if (that.getScopes() != null) {
            ArrayList<AuthorityHolderJSON> references = new ArrayList<AuthorityHolderJSON>();
            for (AuthorityHolder authorityHolder : that.getScopes()) {
                AuthorityHolderJSON ref = new AuthorityHolderJSON();
                ref.setId(authorityHolder.getId());
                references.add(ref);
            }
            this.setScopes(references);
        }
    }

    @Nullable
    public Iterable<AuthorityHolderJSON> getScopes() {
        return this.scopes;
    }

    @XmlTransient
    public void setScopes(@Nullable Iterable<AuthorityHolderJSON> scopes) {
        this.scopes = JsonUtils.iterableToList(scopes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScopedFeature)) {
            return false;
        }
        ScopedFeature that = (ScopedFeature)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ScopedFeatureJSON wrap(@NotNull ScopedFeature that) {
        if (that instanceof ScopedFeatureJSON) {
            return (ScopedFeatureJSON)that;
        }
        return new ScopedFeatureJSON(that);
    }
}

