/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.NamedItem;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Organization;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.OrganizationJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="userGroup")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=UserGroupJSON.class)
@JsonTypeName(value="userGroup")
public class UserGroupJSON
extends AuthorityHolderJSON
implements UserGroup {
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="iconUrl")
    private String iconUrl;
    @XmlElement(name="autoJoin")
    private Boolean autoJoin;
    @XmlElement(name="requiredTwoFactorAuthentication")
    private Boolean requiredTwoFactorAuthentication;
    @XmlElement(name="parentsRequireTwoFactorAuthentication")
    private Boolean parentsRequireTwoFactorAuthentication;
    @XmlElement(name="users")
    private List<UserJSON> users;
    @XmlElement(name="ownUsers")
    private List<UserJSON> ownUsers;
    @XmlElement(name="userCount")
    private Integer userCount;
    @XmlElement(name="parent")
    private UserGroupJSON parent;
    @XmlElement(name="subgroups")
    private List<UserGroupJSON> subgroups;
    @XmlElement(name="teams")
    private List<ProjectTeamJSON> teams;
    @XmlElement(name="organizations")
    private List<OrganizationJSON> organizations;
    @XmlElement(name="project")
    private ProjectJSON project;
    @XmlElement(name="allUsers")
    private Boolean allUsers;
    @XmlElement(name="implicit")
    private Boolean implicit;
    @XmlElement(name="queriedSingleton")
    private Boolean queriedSingleton;
    @XmlElement(name="removable")
    private Boolean removable;

    public UserGroupJSON() {
    }

    public UserGroupJSON(@NotNull UserGroup that) {
        NamedItem ref;
        NamedItem ref2;
        ArrayList<UserJSON> references;
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        this.setDescription(that.getDescription());
        this.setIconUrl(that.getIconUrl());
        this.setAutoJoin(that.isAutoJoin());
        this.setRequiredTwoFactorAuthentication(that.isRequiredTwoFactorAuthentication());
        this.setParentsRequireTwoFactorAuthentication(that.isParentsRequireTwoFactorAuthentication());
        if (that.getUsers() != null) {
            references = new ArrayList<UserJSON>();
            for (User user : that.getUsers()) {
                UserJSON ref22 = new UserJSON();
                ref22.setId(user.getId());
                references.add(ref22);
            }
            this.setUsers(references);
        }
        if (that.getOwnUsers() != null) {
            references = new ArrayList();
            for (User user : that.getOwnUsers()) {
                ref2 = new UserJSON();
                ((AuthorityHolderJSON)ref2).setId(user.getId());
                references.add((UserJSON)ref2);
            }
            this.setOwnUsers(references);
        }
        this.setUserCount(that.getUserCount());
        if (that.getParent() != null) {
            ref = new UserGroupJSON();
            ((AuthorityHolderJSON)ref).setId(that.getParent().getId());
            this.setParent((UserGroupJSON)ref);
        }
        if (that.getSubgroups() != null) {
            aggregated = new ArrayList();
            for (UserGroup userGroup : that.getSubgroups()) {
                aggregated.add((AliasJSON)((Object)new UserGroupJSON(userGroup)));
            }
            this.setSubgroups(aggregated);
        }
        if (that.getTeams() != null) {
            references = new ArrayList();
            for (ProjectTeam projectTeam : that.getTeams()) {
                ref2 = new ProjectTeamJSON();
                ((AuthorityHolderJSON)ref2).setId(projectTeam.getId());
                references.add((UserJSON)ref2);
            }
            this.setTeams(references);
        }
        if (that.getOrganizations() != null) {
            ArrayList<OrganizationJSON> refs = new ArrayList<OrganizationJSON>();
            for (Organization organization : that.getOrganizations()) {
                ref2 = new OrganizationJSON();
                ((OrganizationJSON)ref2).setId(organization.getId());
                refs.add((OrganizationJSON)ref2);
            }
            this.setOrganizations(refs);
        }
        if (that.getProject() != null) {
            ref = new ProjectJSON();
            ((ProjectJSON)ref).setId(that.getProject().getId());
            this.setProject((ProjectJSON)ref);
        }
        this.setAllUsers(that.isAllUsers());
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Override
    @Nullable
    public Boolean isAutoJoin() {
        return this.autoJoin;
    }

    @Override
    public Boolean isRequiredTwoFactorAuthentication() {
        return this.requiredTwoFactorAuthentication;
    }

    @Override
    public Boolean isParentsRequireTwoFactorAuthentication() {
        return this.parentsRequireTwoFactorAuthentication;
    }

    @Nullable
    public Iterable<UserJSON> getUsers() {
        return this.users;
    }

    @Nullable
    public Iterable<UserJSON> getOwnUsers() {
        return this.ownUsers;
    }

    @Override
    @Nullable
    public Integer getUserCount() {
        return this.userCount;
    }

    @Override
    @Nullable
    public Iterable<? extends Organization> getOrganizations() {
        return this.organizations;
    }

    @Override
    @Nullable
    public UserGroupJSON getParent() {
        return this.parent;
    }

    @Nullable
    public Iterable<UserGroupJSON> getSubgroups() {
        return this.subgroups;
    }

    @Nullable
    public Iterable<ProjectTeamJSON> getTeams() {
        return this.teams;
    }

    @Override
    @Nullable
    public ProjectJSON getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public Boolean isAllUsers() {
        return this.allUsers;
    }

    @Nullable
    public Boolean isImplicit() {
        return this.implicit;
    }

    @Override
    @Nullable
    public Boolean isRemovable() {
        return this.removable;
    }

    @Nullable
    public Boolean isQueriedSingleton() {
        return this.queriedSingleton;
    }

    @XmlTransient
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @XmlTransient
    public void setIconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @XmlTransient
    public void setAutoJoin(@Nullable Boolean autoJoin) {
        this.autoJoin = autoJoin;
    }

    @XmlTransient
    public void setRequiredTwoFactorAuthentication(Boolean requiredTwoFactorAuthentication) {
        this.requiredTwoFactorAuthentication = requiredTwoFactorAuthentication;
    }

    @XmlTransient
    public void setParentsRequireTwoFactorAuthentication(Boolean parentsRequireTwoFactorAuthentication) {
        this.parentsRequireTwoFactorAuthentication = parentsRequireTwoFactorAuthentication;
    }

    @XmlTransient
    public void setUsers(@Nullable Iterable<UserJSON> users) {
        this.users = JsonUtils.iterableToList(users);
    }

    @XmlTransient
    public void setOrganizations(@Nullable Iterable<OrganizationJSON> organizations) {
        this.organizations = JsonUtils.iterableToList(organizations);
    }

    @XmlTransient
    public void setOwnUsers(@Nullable Iterable<UserJSON> ownUsers) {
        this.ownUsers = JsonUtils.iterableToList(ownUsers);
    }

    @XmlTransient
    public void setUserCount(@Nullable Integer userCount) {
        this.userCount = userCount;
    }

    @XmlTransient
    public void setParent(@Nullable UserGroupJSON parent) {
        this.parent = parent;
    }

    @XmlTransient
    public void setSubgroups(@Nullable Iterable<UserGroupJSON> subgroups) {
        this.subgroups = JsonUtils.iterableToList(subgroups);
    }

    @XmlTransient
    public void setTeams(@Nullable Iterable<ProjectTeamJSON> teams) {
        this.teams = JsonUtils.iterableToList(teams);
    }

    @XmlTransient
    public void setProject(@Nullable ProjectJSON project) {
        this.project = project;
    }

    @XmlTransient
    public void setAllUsers(@Nullable Boolean allUsers) {
        this.allUsers = allUsers;
    }

    @XmlTransient
    public void setImplicit(@Nullable Boolean implicit) {
        this.implicit = implicit;
    }

    @XmlTransient
    public void setRemovable(@Nullable Boolean removable) {
        this.removable = removable;
    }

    @XmlTransient
    public void setQueriedSingleton(@Nullable Boolean queriedSingleton) {
        this.queriedSingleton = queriedSingleton;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserGroup)) {
            return false;
        }
        UserGroup that = (UserGroup)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static UserGroupJSON wrap(@NotNull UserGroup that) {
        if (that instanceof UserGroupJSON) {
            return (UserGroupJSON)that;
        }
        return new UserGroupJSON(that);
    }
}

