/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.license.checker;

import jetbrains.ring.license.License;
import jetbrains.ring.license.checker.CantBanGuestException;
import jetbrains.ring.license.checker.LicenseLimitException;
import jetbrains.ring.license.checker.LicenseUserNumberExceededException;
import jetbrains.ring.license.checker.UpgradeExpiredException;
import org.jetbrains.annotations.NotNull;

public interface LicenseChecker {
    @NotNull
    public License getLicense();

    public void checkProduct() throws LicenseLimitException;

    public void checkHosted() throws LicenseLimitException;

    public void checkCanBan(boolean var1) throws CantBanGuestException;

    public void checkAllowsMoreUsers() throws LicenseUserNumberExceededException;

    public void checkExpiration() throws LicenseLimitException;

    public void checkUpgradeExpiration() throws UpgradeExpiredException;

    public void checkMajorVersion() throws LicenseLimitException;

    public void checkMinorVersion() throws LicenseLimitException;

    public void checkBuildStatus() throws LicenseLimitException;

    public void checkBasicValidity() throws LicenseLimitException;

    public void checkAllowsMoreProjects() throws LicenseLimitException;

    public void checkAllowsMoreIssues() throws LicenseLimitException;

    public void checkCanChangeLogo() throws LicenseLimitException;

    public void checkDiskUsage() throws LicenseLimitException;
}

