/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.license.checker;

import java.util.concurrent.TimeUnit;
import jetbrains.ring.license.BuildStatus;
import jetbrains.ring.license.License;
import jetbrains.ring.license.checker.ApplicationDescriptor;
import jetbrains.ring.license.checker.CantBanGuestException;
import jetbrains.ring.license.checker.CantChangeLogoException;
import jetbrains.ring.license.checker.InvalidBuildException;
import jetbrains.ring.license.checker.InvalidMajorVersionException;
import jetbrains.ring.license.checker.InvalidMinorVersionException;
import jetbrains.ring.license.checker.InvalidProductException;
import jetbrains.ring.license.checker.LicenseChecker;
import jetbrains.ring.license.checker.LicenseDiskSpaceExceededException;
import jetbrains.ring.license.checker.LicenseExpiredException;
import jetbrains.ring.license.checker.LicenseIssueNumberExceededException;
import jetbrains.ring.license.checker.LicenseLimitException;
import jetbrains.ring.license.checker.LicenseProjectNumberExceededException;
import jetbrains.ring.license.checker.LicenseUserNumberExceededException;
import jetbrains.ring.license.checker.NotGeneratedLicenseException;
import jetbrains.ring.license.checker.NotHostedLicenseException;
import jetbrains.ring.license.checker.NotStandaloneLicenseException;
import jetbrains.ring.license.checker.UpgradeExpiredException;
import org.jetbrains.annotations.NotNull;

public class LicenseCheckerImpl
implements LicenseChecker {
    @NotNull
    private final License license;
    @NotNull
    private final ApplicationDescriptor applicationDescriptor;

    public LicenseCheckerImpl(@NotNull License license, @NotNull ApplicationDescriptor applicationDescriptor) {
        this.license = license;
        this.applicationDescriptor = applicationDescriptor;
    }

    @Override
    @NotNull
    public License getLicense() {
        return this.license;
    }

    @NotNull
    public ApplicationDescriptor getApplicationDescriptor() {
        return this.applicationDescriptor;
    }

    @Override
    public void checkProduct() throws LicenseLimitException {
        if (this.license.getProduct() != this.applicationDescriptor.getProduct()) {
            throw new InvalidProductException(this.license);
        }
    }

    @Override
    public void checkHosted() throws LicenseLimitException {
        boolean isRunningInCloud = this.applicationDescriptor.isHosted();
        if (this.license.isHosted() && !isRunningInCloud) {
            throw new NotStandaloneLicenseException(this.license);
        }
        if (!this.license.isHosted() && isRunningInCloud) {
            throw new NotHostedLicenseException(this.license);
        }
    }

    @Override
    public void checkCanBan(boolean guest) throws CantBanGuestException {
        if (guest && this.license.isGuestBanForbidden()) {
            throw new CantBanGuestException(this.license);
        }
    }

    @Override
    public void checkAllowsMoreUsers() throws LicenseUserNumberExceededException {
        if (this.license.getUserCount() != Integer.MAX_VALUE && this.applicationDescriptor.getUsersNumber() >= this.license.getUserCount() + this.license.getReporterCount()) {
            throw new LicenseUserNumberExceededException(this.license);
        }
    }

    @Override
    public void checkExpiration() throws LicenseLimitException {
        if (this.license.getGenerationTime() >= this.now() + TimeUnit.DAYS.toMillis(1L)) {
            throw new NotGeneratedLicenseException(this.license);
        }
        if (this.license.getExpirationTime() < this.now()) {
            throw new LicenseExpiredException(this.license);
        }
    }

    @Override
    public void checkUpgradeExpiration() throws UpgradeExpiredException {
        if (this.license.getUpgradeExpirationTime() < this.applicationDescriptor.getReleaseDate()) {
            throw new UpgradeExpiredException(this.license);
        }
    }

    @Override
    public void checkMajorVersion() throws LicenseLimitException {
        if (this.license.getMajorVersion() != Integer.MAX_VALUE && this.license.getMajorVersion() != this.applicationDescriptor.getMajorVersion()) {
            throw new InvalidMajorVersionException(this.license);
        }
    }

    @Override
    public void checkMinorVersion() throws LicenseLimitException {
        if (this.license.getMinorVersion() != Integer.MAX_VALUE && this.license.getMinorVersion() != this.applicationDescriptor.getMinorVersion()) {
            throw new InvalidMinorVersionException(this.license);
        }
    }

    @Override
    public void checkBuildStatus() throws LicenseLimitException {
        int license = this.license.getBuildNumber();
        BuildStatus buildStatus = this.applicationDescriptor.getBuildStatus();
        if (license == Integer.MAX_VALUE) {
            return;
        }
        if (license == 1000000 && buildStatus == BuildStatus.EAP) {
            return;
        }
        if (license == 1000001 && buildStatus == BuildStatus.BETA) {
            return;
        }
        if (license == 1000002 && buildStatus == BuildStatus.RELEASE_CANDIDATE) {
            return;
        }
        if (license == this.applicationDescriptor.getBuildNumber()) {
            return;
        }
        throw new InvalidBuildException(this.license);
    }

    @Override
    public void checkBasicValidity() throws LicenseLimitException {
        this.checkProduct();
        this.checkHosted();
        this.checkExpiration();
        if (this.getLicense().getUpgradeExpirationTime() != this.getLicense().getGenerationTime()) {
            this.checkUpgradeExpiration();
        } else {
            this.checkMajorVersion();
            this.checkMinorVersion();
            this.checkBuildStatus();
        }
    }

    @Override
    public void checkAllowsMoreProjects() throws LicenseLimitException {
        if (this.license.getProjectCount() != Integer.MAX_VALUE && this.applicationDescriptor.getProjectNumber() >= this.license.getProjectCount()) {
            throw new LicenseProjectNumberExceededException(this.license);
        }
    }

    @Override
    public void checkAllowsMoreIssues() throws LicenseLimitException {
        if (this.license.getIssueCount() != Long.MAX_VALUE && this.applicationDescriptor.getIssueNumber() >= this.license.getIssueCount()) {
            throw new LicenseIssueNumberExceededException(this.license);
        }
    }

    @Override
    public void checkDiskUsage() throws LicenseLimitException {
        if (this.license.getDiskSpace() != Integer.MAX_VALUE && this.applicationDescriptor.getDiskUsage() >= this.license.getDiskSpace()) {
            throw new LicenseDiskSpaceExceededException(this.license);
        }
    }

    @Override
    public void checkCanChangeLogo() throws LicenseLimitException {
        if (this.license.isLogoChangeForbidden()) {
            throw new CantChangeLogoException(this.license);
        }
    }

    protected long now() {
        return System.currentTimeMillis();
    }
}

