/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.license.reader;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import jetbrains.ring.license.License;
import jetbrains.ring.license.LicenseFlag;
import jetbrains.ring.license.LicenseType;
import jetbrains.ring.license.Product;
import jetbrains.ring.license.reader.EmptyLicenseKeyException;
import jetbrains.ring.license.reader.EmptyLicenseNameException;
import jetbrains.ring.license.reader.InvalidLicenseFormatException;
import jetbrains.ring.license.reader.InvalidLicenseNameException;
import jetbrains.ring.license.reader.InvalidLicenseSignatureException;
import jetbrains.ring.license.reader.LicenseReadException;
import jetbrains.ring.license.reader.LicenseUtil;
import jetbrains.ring.license.reader.MajorVersionEncoder;
import jetbrains.ring.license.reader.UnknownLicenseTypeException;
import jetbrains.ring.license.reader.UnknownProductException;
import org.jetbrains.annotations.NotNull;

public class LicenseReader {
    private final BigInteger rsaMOD;

    public LicenseReader() {
        this.rsaMOD = LicenseUtil.RSA_MOD;
    }

    public LicenseReader(BigInteger rsaMOD) {
        this.rsaMOD = rsaMOD;
    }

    public License read(final String licenseName, String licenseKey) throws LicenseReadException {
        BigInteger licenseNumber;
        if (licenseName == null || licenseName.length() == 0) {
            throw new EmptyLicenseNameException();
        }
        if (licenseKey == null || licenseKey.length() == 0) {
            throw new EmptyLicenseKeyException();
        }
        try {
            licenseNumber = new BigInteger(licenseKey, 16);
        }
        catch (NumberFormatException e) {
            throw new InvalidLicenseFormatException();
        }
        BitStream license = new BitStream(licenseNumber.modPow(LicenseUtil.THREE, this.rsaMOD));
        BigInteger licenseMD5 = license.readBigInteger(128);
        if (!licenseMD5.equals(LicenseUtil.getLicenseMD5(license.getStream()))) {
            throw new InvalidLicenseSignatureException();
        }
        BigInteger usernameMD5 = license.readBigInteger(128);
        if (!usernameMD5.equals(LicenseUtil.getUsernameMD5(licenseName))) {
            throw new InvalidLicenseNameException();
        }
        int productCode = license.readInt(16);
        final Product product = Product.valueOf(productCode);
        if (product == null) {
            throw new UnknownProductException(productCode);
        }
        final int majorVersion = MajorVersionEncoder.decodeMajorVersion(license.readInt(10, Integer.MAX_VALUE));
        final int minorVersion = license.readInt(10, Integer.MAX_VALUE);
        final int buildNumber = license.readInt(20, Integer.MAX_VALUE);
        int licenseTypeCode = license.readInt(4);
        final LicenseType licenseType = LicenseType.valueOf(licenseTypeCode);
        if (licenseType == null) {
            throw new UnknownLicenseTypeException(licenseTypeCode);
        }
        final long generationTime = license.readLong(63);
        final long expirationTime = license.readLong(63, Long.MAX_VALUE);
        final int userCount = license.readInt(31);
        final long issueCount = license.readLong(63, Long.MAX_VALUE);
        final int projectCount = license.readInt(31, Integer.MAX_VALUE);
        final long flags = license.readLong(63);
        long freeUpgradeDays = license.readInt(15);
        final long upgradeExpirationTime = freeUpgradeDays == 0L ? (LicenseFlag.HOSTED_SOLUTION.hasFlag(flags) ? Long.MAX_VALUE : generationTime + 31536000000L) : generationTime + freeUpgradeDays * 86400000L;
        int diskSpaceMB = license.readInt(31);
        final int diskSpace = diskSpaceMB > 0 ? diskSpaceMB : Integer.MAX_VALUE;
        final int reporterCount = license.readInt(12) * 10;
        return new License(){

            @Override
            @NotNull
            public String getName() {
                return licenseName;
            }

            @Override
            @NotNull
            public Product getProduct() {
                return product;
            }

            @Override
            public int getMajorVersion() {
                return majorVersion;
            }

            @Override
            public int getMinorVersion() {
                return minorVersion;
            }

            @Override
            public int getBuildNumber() {
                return buildNumber;
            }

            @Override
            @NotNull
            public LicenseType getLicenseType() {
                return licenseType;
            }

            @Override
            public long getGenerationTime() {
                return generationTime;
            }

            @Override
            public long getExpirationTime() {
                return expirationTime;
            }

            @Override
            public long getUpgradeExpirationTime() {
                return upgradeExpirationTime;
            }

            @Override
            public int getUserCount() {
                return userCount;
            }

            @Override
            public int getProjectCount() {
                return projectCount;
            }

            @Override
            public int getDiskSpace() {
                return diskSpace;
            }

            @Override
            public boolean isHosted() {
                return LicenseFlag.HOSTED_SOLUTION.hasFlag(flags);
            }

            @Override
            public boolean isLogoChangeForbidden() {
                return LicenseFlag.CHANGE_LOGO_FORBIDDEN.hasFlag(flags);
            }

            @Override
            public boolean isGuestBanForbidden() {
                return LicenseFlag.BAN_GUEST_FORBIDDEN.hasFlag(flags);
            }

            @Override
            public boolean isHttpsAllowed() {
                return LicenseFlag.HTTPS_ENABLED.hasFlag(flags);
            }

            @Override
            public int getReporterCount() {
                return reporterCount;
            }

            @Override
            public long getIssueCount() {
                return issueCount;
            }

            @Override
            public boolean isLdapEnabled() {
                return LicenseFlag.LDAP.hasFlag(flags);
            }

            @Override
            public boolean isTrackerDisabled() {
                return LicenseFlag.TRACKER_DISABLED.hasFlag(flags);
            }

            @Override
            public boolean isAgileDisabled() {
                return LicenseFlag.AGILE_DISABLED.hasFlag(flags);
            }

            public String toString() {
                return "License{name=\"" + this.getName() + "\", users=" + (this.getUserCount() == Integer.MAX_VALUE ? "unlimited" : Integer.valueOf(this.getUserCount())) + ", product=" + this.getProduct().name() + ", status=" + (this.getBuildNumber() == Integer.MAX_VALUE ? "any" : (this.getBuildNumber() == 1000000 ? "EAP" : (this.getBuildNumber() == 1000001 ? "beta" : (this.getBuildNumber() == 1000002 ? "RC" : Integer.valueOf(this.getBuildNumber()))))) + ", majorVersion=" + (this.getMajorVersion() == Integer.MAX_VALUE ? "any" : Integer.valueOf(this.getMajorVersion())) + ", licenseType=" + this.getLicenseType().name() + ", expiration=" + (this.getExpirationTime() == Long.MAX_VALUE ? "never" : new SimpleDateFormat("yyyy-MMM-dd").format(new Date(this.getExpirationTime()))) + ", upgradeExpiration=" + (this.getUpgradeExpirationTime() == Long.MAX_VALUE ? "never" : new SimpleDateFormat("yyyy-MMM-dd").format(new Date(this.getUpgradeExpirationTime()))) + "}";
            }
        };
    }

    private static class BitStream {
        private BigInteger stream;

        public BitStream(BigInteger stream) {
            this.stream = stream;
        }

        public BigInteger getStream() {
            return this.stream;
        }

        public BigInteger readBigInteger(int bitLength) {
            BigInteger mask = BigInteger.ONE.shiftLeft(bitLength).subtract(BigInteger.ONE);
            BigInteger value = this.stream.and(mask);
            this.stream = this.stream.shiftRight(bitLength);
            return value;
        }

        public long readLong(int bitLength) {
            long result = this.stream.longValue();
            this.stream = this.stream.shiftRight(bitLength);
            return bitLength < 63 ? result & (1L << bitLength) - 1L : result & Long.MAX_VALUE;
        }

        public long readLong(int bitLength, long broadcastValue) {
            long result = this.readLong(bitLength);
            return result < (1L << bitLength) - 1L ? result : broadcastValue;
        }

        public int readInt(int bitLength) {
            int result = this.stream.intValue();
            this.stream = this.stream.shiftRight(bitLength);
            return bitLength < 31 ? result & (1 << bitLength) - 1 : result & Integer.MAX_VALUE;
        }

        public int readInt(int bitLength, int broadcastValue) {
            int result = this.readInt(bitLength);
            return result < (1 << bitLength) - 1 ? result : broadcastValue;
        }
    }
}

