/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.license.reader;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;

public class LicenseUtil {
    public static final int MD5_BITLEN = 128;
    public static final BigInteger RSA_MOD = new BigInteger("263209838529653741309366162078767955401650210060093940479440536241110980313794956537153327107041219371342779419863684554849202277263853757273750327567871802106538309185809561001712198328099404198770096988081455939118836298393133358550417396551205893870871649995935725104508543665608276612812277299875371100701");
    public static final BigInteger THREE = BigInteger.valueOf(3L);
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_YEAR = 31536000000L;

    public static BigInteger getUsernameMD5(@NotNull String username) {
        MessageDigest md5 = LicenseUtil.getMD5();
        try {
            md5.update(username.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new BigInteger(1, md5.digest());
    }

    public static BigInteger getLicenseMD5(@NotNull BigInteger license) {
        MessageDigest md5 = LicenseUtil.getMD5();
        md5.update(license.toByteArray());
        return new BigInteger(1, md5.digest());
    }

    public static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

