/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.springframework.configuration.runtime;

import java.util.Map;
import jetbrains.springframework.configuration.runtime.IServiceLocator;
import jetbrains.springframework.configuration.runtime.PlaceholderResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class VolatileServiceLocatorDelegate
implements IServiceLocator {
    static volatile IServiceLocator INSTANCE;

    @Override
    public boolean isFake() {
        return true;
    }

    protected static IServiceLocator instance() {
        IServiceLocator result = INSTANCE;
        if (result == null) {
            throw new IllegalStateException("ServiceLocator is not initialized.");
        }
        return result;
    }

    @Override
    public PlaceholderResolver getResolver() {
        return VolatileServiceLocatorDelegate.instance().getResolver();
    }

    @Override
    public Object getBean(String id) {
        return VolatileServiceLocatorDelegate.instance().getBean(id);
    }

    @Override
    public boolean beanDefined(String id) {
        return VolatileServiceLocatorDelegate.instance().beanDefined(id);
    }

    @Override
    public void setTestBean(String id, Object testBeanImplementation) {
        VolatileServiceLocatorDelegate.instance().setTestBean(id, testBeanImplementation);
    }

    @Override
    public Object getOptionalBean(String id) {
        return VolatileServiceLocatorDelegate.instance().getOptionalBean(id);
    }

    @Override
    public Map getBeansOfType(Class type) {
        return VolatileServiceLocatorDelegate.instance().getBeansOfType(type);
    }

    @Override
    public Map getLocalBeansOfType(Class type) {
        return VolatileServiceLocatorDelegate.instance().getLocalBeansOfType(type);
    }

    @Override
    public ResourcePatternResolver getResourceLoader() {
        return VolatileServiceLocatorDelegate.instance().getResourceLoader();
    }

    @Override
    public void init() {
        VolatileServiceLocatorDelegate.instance().init();
    }

    @Override
    public void close() {
        VolatileServiceLocatorDelegate.instance().close();
    }

    @Override
    public void closeLocal() {
        VolatileServiceLocatorDelegate.instance().closeLocal();
    }
}

