/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceLoader {
    private static Log log = LogFactory.getLog(ResourceLoader.class);

    public static Enumeration<URL> findAllResources(URLClassLoader classLoader) {
        final URL[] urls = classLoader.getURLs();
        return new Enumeration<URL>(){
            private URL url = null;
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.advance();
            }

            @Override
            public URL nextElement() {
                if (!this.advance()) {
                    throw new NoSuchElementException();
                }
                URL u = ResourceLoader.fixURL(this.url);
                this.url = null;
                return u;
            }

            public boolean advance() {
                if (this.url != null) {
                    return true;
                }
                if (this.index >= urls.length) {
                    return false;
                }
                do {
                    try {
                        URL u = urls[this.index];
                        ResourceLoader.check(u);
                        this.url = u;
                    }
                    catch (IOException ex) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"File not found, will be skipped.", (Throwable)ex);
                    }
                } while (++this.index < urls.length && this.url == null);
                return this.url != null;
            }
        };
    }

    private static URL fixURL(URL u) {
        block3: {
            String extForm = u.toExternalForm();
            if (extForm.lastIndexOf(".") > 0 && extForm.substring(extForm.lastIndexOf(".")).contains(".jar")) {
                try {
                    u = new URL("jar:" + extForm + (extForm.endsWith("!") ? "" : "!") + "/");
                }
                catch (MalformedURLException ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)("Can't open jar " + u.toExternalForm()), (Throwable)ex);
                }
            }
        }
        return u;
    }

    private static void check(URL url) throws IOException {
        URLConnection connection;
        Permission permission;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (permission = (connection = url.openConnection()).getPermission()) != null) {
            try {
                security.checkPermission(permission);
            }
            catch (SecurityException se) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Fails security permission", (Throwable)se);
                }
                throw se;
            }
        }
    }
}

