/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.htmlComponent.bl;

import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.htmlComponent.bl.Range;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import webr.framework.runtime.response.CommandResponseAction;
import webr.framework.runtime.response.CommandScriptor;
import webr.framework.runtime.response.JsCommandResponse;
import webr.framework.textBuilder.TBuilderContext;

public class HtmlTextComponent {
    public static JsCommandResponse underline(final String component, final String query, final Iterable<Range> ranges, final int optinalLeftOffset) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").underline(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)query));
                builderContext.append("\", [");
                boolean first = true;
                if (ranges != null) {
                    for (Range range : Sequence.fromIterable((Iterable)ranges)) {
                        int start = range.getStart();
                        int end = range.getEnd();
                        if (!first) {
                            builderContext.append(",");
                        } else {
                            first = false;
                        }
                        builderContext.append("{start: ");
                        builderContext.append(String.valueOf(start));
                        builderContext.append(", end: ");
                        builderContext.append(String.valueOf(end));
                        builderContext.append(", type: ");
                        builderContext.append(String.valueOf(range.getType()));
                        builderContext.append("}");
                    }
                }
                builderContext.append("], ");
                builderContext.append(String.valueOf(optinalLeftOffset));
                builderContext.append(");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse highlight(final String component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").highlight(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse highlight(final String component, final String message, final boolean dismissOnChange, final boolean focus) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").highlight(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", null, ");
                builderContext.append(Boolean.toString(dismissOnChange));
                builderContext.append(", ");
                builderContext.append(Boolean.toString(focus));
                builderContext.append(");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse unHighlight(final String component) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").unHighlight();");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public static JsCommandResponse focus(final String component) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create((CommandScriptor)new CommandScriptor(){

            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("document.getElementById(\"id_\" + \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)component));
                builderContext.append("\").focus();");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }
}

