/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.htmlComponent.runtime;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import jetbrains.mps.webr.runtime.converter.ConvertException;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.templateComponent.LayoutComponent;
import jetbrains.mps.webr.runtime.templateComponent.LinkUtil;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import jetbrains.mps.webr.runtime.templateComponent.TemplateDependencyManager;
import jetbrains.mps.webr.runtime.templateComponent.Widget;
import jetbrains.mps.webr.runtime.templateComponent.WidgetFake;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.exception.LabeledInputException;
import webr.framework.textBuilder.TBuilderContext;

public class HtmlComponentUtil {
    public static final String COMPONENT_PARAMS = "__COMPONENT_PARAMS__";
    public static final String COMPONENT_SOURCE = "__COMPONENT_SOURCE__";

    private HtmlComponentUtil() {
    }

    public static <T> T getParameter(int index, Class<T> parameterType) {
        Object value;
        String[] valuesAsString = HtmlComponentUtil.getParameterValues();
        if (valuesAsString == null) {
            return null;
        }
        if (0 > index && index >= valuesAsString.length) {
            return null;
        }
        String valueS = valuesAsString[index];
        try {
            String parameterTypeName = parameterType.getName();
            value = ((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString(valueS, parameterTypeName);
        }
        catch (ConvertException e) {
            throw new LabeledInputException(e, COMPONENT_PARAMS);
        }
        return (T)value;
    }

    public static Widget getSource() {
        String sourceId = BaseApplication.getRequest().getParameter(COMPONENT_SOURCE);
        return new WidgetFake(sourceId);
    }

    private static String[] getParameterValues() {
        return BaseApplication.getRequest().getParameterValues(COMPONENT_PARAMS);
    }

    public static void addTemplateParamAttributes(TBuilderContext builderContext) {
        HtmlComponentUtil.addTemplateParamAttributes(builderContext, builderContext.getCurrentTemplateComponent());
    }

    private static int addTemplateParamAttributes(TBuilderContext builderContext, TemplateComponent t) {
        if (t == null) {
            return 0;
        }
        int i = HtmlComponentUtil.addTemplateParamAttributes(builderContext, t.getParentTemplateComponent());
        if (t.getCallParam() != null) {
            builderContext.append(" tp");
            builderContext.append(i);
            builderContext.append("=\"");
            builderContext.append(((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).toString(t.getCallParam()));
            builderContext.append("\"");
        }
        return i + 1;
    }

    private static void buildTemplatePaths(TemplateComponent parent, Map<String, Set<String>> paths, TemplateDependencyManager jsm, StringBuilder builder) {
        for (TemplateComponent child : parent.getChildrenTemplateComponents().values()) {
            String templateName = jsm.getTemplateName(child.getClass().getName());
            Set tpaths = (Set)MapSequence.fromMap(paths).get((Object)templateName);
            if (tpaths == null) {
                tpaths = SetSequence.fromSet(new HashSet());
                MapSequence.fromMap(paths).put((Object)templateName, (Object)tpaths);
            }
            builder.setLength(0);
            child.getRefPath(builder);
            SetSequence.fromSet((Set)tpaths).addElement((Object)StringInterner.intern((String)builder.toString()));
            HtmlComponentUtil.buildTemplatePaths(child, paths, jsm, builder);
        }
    }

    private static void jsTemplatePaths(Map<String, Set<String>> paths, TBuilderContext builderContext) {
        LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.mps.webr.htmlComponent.js.ComponentRegistry2", "jetbrains.mps.webr.jquery.jquery"}));
        builderContext.appendIndent();
        builderContext.append("<script type=\"text/javascript\"");
        builderContext.append(LinkUtil.DEFER_STRING);
        builderContext.append(">");
        builderContext.appendIndent();
        LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.mps.webr.htmlComponent.js.ComponentRegistry2", "jetbrains.mps.webr.jquery.jquery"}));
        builderContext.appendIndent();
        builderContext.append("$(document).ready(function () {");
        builderContext.appendNewLine();
        builderContext.increaseIndent();
        builderContext.appendIndent();
        builderContext.appendIndent();
        builderContext.append("cr.setTemplatePaths([");
        boolean firstTemplate = true;
        for (String name : MapSequence.fromMap(paths).keySet()) {
            if (!firstTemplate) {
                builderContext.append(",");
            } else {
                firstTemplate = false;
            }
            builderContext.append("{name: \"");
            builderContext.append(JsStringUtil.stringLiteral((Object)name));
            builderContext.append("\", paths: [");
            boolean firstPath = true;
            for (String path : (Set)MapSequence.fromMap(paths).get((Object)name)) {
                if (!firstPath) {
                    builderContext.append(",");
                } else {
                    firstPath = false;
                }
                builderContext.append("{path: \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)path));
                builderContext.append("\"}");
            }
            builderContext.append("]}");
        }
        builderContext.append("]);");
        builderContext.appendNewLine();
        builderContext.appendNewLine();
        builderContext.decreaseIndent();
        builderContext.appendIndent();
        builderContext.append("});");
        builderContext.appendNewLine();
        builderContext.appendNewLine();
        builderContext.append("</script>");
        builderContext.appendNewLine();
    }

    public static void addTemplatePaths(TBuilderContext builderContext, TemplateComponent root) {
        IMapSequence paths = MapSequence.fromMap(new HashMap());
        MapSequence.fromMap((Map)paths).put((Object)((TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager")).getTemplateName(root), (Object)SetSequence.fromSetAndArray(new HashSet(), (Object[])new String[]{root.getRefPath()}));
        HtmlComponentUtil.buildTemplatePaths(root, (Map<String, Set<String>>)paths, (TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager"), new StringBuilder());
        HtmlComponentUtil.jsTemplatePaths((Map<String, Set<String>>)paths, builderContext);
        LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.mps.webr.htmlComponent.js.ComponentRegistry2", "jetbrains.mps.webr.jquery.jquery"}));
        builderContext.appendIndent();
        builderContext.append("<script type=\"text/javascript\"");
        builderContext.append(LinkUtil.DEFER_STRING);
        builderContext.append(">");
        builderContext.appendIndent();
        LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.mps.webr.htmlComponent.js.ComponentRegistry2", "jetbrains.mps.webr.jquery.jquery"}));
        builderContext.appendIndent();
        builderContext.append("$(document).ready(function () {");
        builderContext.appendNewLine();
        builderContext.increaseIndent();
        builderContext.appendIndent();
        builderContext.append("var rootToRefresh = document.getElementById(\"");
        builderContext.append(JsStringUtil.stringLiteral((Object)root.getRefreshElementId()));
        builderContext.append("\");");
        builderContext.appendNewLine();
        builderContext.appendIndent();
        builderContext.append("if (rootToRefresh) {");
        builderContext.appendNewLine();
        builderContext.increaseIndent();
        builderContext.appendIndent();
        builderContext.append("cr.onTemplateRefresh(rootToRefresh);");
        builderContext.appendNewLine();
        builderContext.decreaseIndent();
        builderContext.appendIndent();
        builderContext.append("}");
        builderContext.appendNewLine();
        builderContext.appendNewLine();
        builderContext.decreaseIndent();
        builderContext.appendIndent();
        builderContext.append("});");
        builderContext.appendNewLine();
        builderContext.appendNewLine();
        builderContext.append("</script>");
        builderContext.appendNewLine();
    }

    public static void addTemplatePaths(TBuilderContext builderContext) {
        LayoutComponent layout = (LayoutComponent)builderContext.getCurrentTemplateComponent().getRootTemplateComponent();
        TemplateComponent root = layout.getNestedTemplateComponent();
        IMapSequence paths = MapSequence.fromMap(new HashMap());
        MapSequence.fromMap((Map)paths).put((Object)((TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager")).getTemplateName((TemplateComponent)layout), (Object)SetSequence.fromSetAndArray(new HashSet(), (Object[])new String[]{layout.getRefPath()}));
        MapSequence.fromMap((Map)paths).put((Object)((TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager")).getTemplateName(root), (Object)SetSequence.fromSetAndArray(new HashSet(), (Object[])new String[]{root.getRefPath()}));
        StringBuilder builder = new StringBuilder();
        HtmlComponentUtil.buildTemplatePaths((TemplateComponent)layout, (Map<String, Set<String>>)paths, (TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager"), builder);
        HtmlComponentUtil.buildTemplatePaths(root, (Map<String, Set<String>>)paths, (TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager"), builder);
        HtmlComponentUtil.jsTemplatePaths((Map<String, Set<String>>)paths, builderContext);
        LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.mps.webr.htmlComponent.js.ComponentRegistry2", "jetbrains.mps.webr.jquery.jquery"}));
        builderContext.appendIndent();
        builderContext.append("<script type=\"text/javascript\"");
        builderContext.append(LinkUtil.DEFER_STRING);
        builderContext.append(">");
        builderContext.appendIndent();
        LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.mps.webr.htmlComponent.js.ComponentRegistry2", "jetbrains.mps.webr.jquery.jquery"}));
        builderContext.appendIndent();
        builderContext.append("$(document).ready(function () {");
        builderContext.appendNewLine();
        builderContext.increaseIndent();
        builderContext.appendIndent();
        builderContext.append("cr.onDocumentLoad();");
        builderContext.appendNewLine();
        builderContext.decreaseIndent();
        builderContext.appendIndent();
        builderContext.append("});");
        builderContext.appendNewLine();
        builderContext.appendNewLine();
        builderContext.append("</script>");
        builderContext.appendNewLine();
    }

    public static void addResponseTimeJs(TBuilderContext builderContext) {
        builderContext.appendIndent();
        LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.mps.webr.htmlComponent.js.Debug", "jetbrains.mps.webr.jquery.jquery"}));
        builderContext.appendNewLine();
        builderContext.startContentBlock("__JAVASCRIPT_CONTENT__");
        builderContext.appendIndent();
        builderContext.append("$(\"#__RESPONSE_TIME_CONTENT__\").replaceWith(document.createTextNode(\"");
        builderContext.append(JsStringUtil.stringLiteral((Object)HtmlComponentUtil.getFormatedNanons(System.nanoTime() - builderContext.getInitTime())));
        builderContext.append("\"));");
        builderContext.appendNewLine();
        builderContext.appendIndent();
        builderContext.append("info(\"End of the response\");");
        builderContext.appendNewLine();
        builderContext.endContentBlock();
    }

    private static String getFormatedNanons(long nanos) {
        return MessageFormat.format("{0,number,#} ms", (double)nanos / 1000000.0);
    }
}

