Webr.component.BindedComboRenderer = function (anchor, mainElement, rootElement) {
  Webr.component.BindedComboRenderer.superclass.constructor.call(this, anchor, rootElement);
  //TODO: Reset layouter from super class
  this.setLayouter(new Webr.component.FullLayouter(this.getLayouterConfig()));
  this.anchorElement = $(anchor);
  this.mainElement = this.createMainElement($(mainElement), $(rootElement));
  this.setRootElement(this.mainElement);
};
{
  var F = new Function();
  F.prototype = Webr.component.ComboRenderer.prototype;
  Webr.component.BindedComboRenderer.prototype = new F();
  Webr.component.BindedComboRenderer.prototype.constructor = Webr.component.BindedComboRenderer;
  Webr.component.BindedComboRenderer.superclass = Webr.component.ComboRenderer.prototype;
}

Webr.component.BindedComboRenderer.prototype.getContainer = function () {
  return this.mainElement;
};
Webr.component.BindedComboRenderer.prototype.createMainElement = function (element, rootElement) {
  var _wrap = $(document.createElement("div")).addClass("inputWrapper");
  //Copy classes and styles from target element
  //_cn_ is for testing support purposes
  var container = $(document.createElement("div")).attr({"class": element.attr("class"), "style": element.attr("style"), "_cn_": element.attr("id")}).append(_wrap);
  var input = document.createElement("input");
  input.name = element.get(0).id.substring(3);
  input.setAttribute("valueId", element.attr("_valueId"));
  _wrap.append(input).append(this.loading);
  this.inputElement = $(input);
  var position = this.bindedPosition();
  container.css("left", position.left).css("top", position.top).hide().appendTo(rootElement);
  return container;
};
Webr.component.BindedComboRenderer.prototype.bindedPosition = function () {
  var pos = {top: this.anchorElement.offset().top - this.rootElement.offset().top, left: this.anchorElement.offset().left - this.rootElement.offset().left};
  var position = {top: pos.top + this.anchorElement.outerHeight(true), left: pos.left - this.getContainer().outerWidth() + this.anchorElement.outerWidth()};
  return position;
};
Webr.component.BindedComboRenderer.prototype.countPosition = function () {
  return {left: 0, top: 0};
};
Webr.component.BindedComboRenderer.prototype.isAncestorOf = function (element) {
  return this.getContainer().ancestorOf(element);
};
Webr.component.BindedComboRenderer.prototype.getHeight = function () {
  return this.mainElement.outerHeight(true) + this.comboContainer.outerHeight(true);
};
Webr.component.BindedComboRenderer.prototype.hide = function () {
  this.mainElement.hide();
  Webr.component.BindedComboRenderer.superclass.hide.call(this);
};
Webr.component.BindedComboRenderer.prototype.show = function () {
  this.mainElement.show();
  Webr.component.BindedComboRenderer.superclass.show.call(this);
  this.shadow.setTop(this.createComboContainer().position().top);
};
Webr.component.BindedComboRenderer.prototype.getLoadingElement = function () {
  return this.loading;
};
Webr.component.BindedComboRenderer.prototype.showLoading = function (timeout) {
  //ignore timeout
  //Fix WD-1497

  Webr.component.BindedComboRenderer.superclass.showLoading.call(this);
  this.mainElement.show();
  this.inputElement.focus();
};
Webr.component.BindedComboRenderer.prototype.hideLoading = function () {
  this.mainElement.hide();
  Webr.component.BindedComboRenderer.superclass.hideLoading.call(this);
};
Webr.component.BindedComboRenderer.prototype.destroy = function () {
  this.mainElement.remove();
  this.anchorElement.remove();
};
Webr.component.BindedComboRenderer.prototype.move = function (direction, maxHeight, preffered) {
  switch (direction) {
  case Webr.component.Layouter.UP:
    this.getContainer().addClass("reversal");
    this.shadow.relayout(true);
    this.setComboContainerPositionAndHeight(this.anchorElement.offset().top - this.getContainer().outerHeight(true), maxHeight, preffered);
    this.setExtraContentPosition();
        break;

  case Webr.component.Layouter.DOWN:
    if (false) {
      this.setComboContainerPositionAndHeight(this.anchorElement.offset().top + this.anchorElement.outerHeight(true), maxHeight, preffered);
      this.setExtraContentPosition();
    }

        break;

  case Webr.component.Layouter.LEFT:
    this.getContainer().css({left: this.anchorElement.offset().left - this.getContainer().outerWidth() + this.anchorElement.outerWidth()});
        break;

  case Webr.component.Layouter.RIGHT:
    this.getContainer().css({left: this.anchorElement.offset().left});
  }

};
Webr.component.BindedComboRenderer.prototype.reset = function () {
  this.getContainer().removeClass("reversal").css("top", this.anchorElement.offset().top + this.anchorElement.outerHeight(true));
  this.shadow.relayout(false);
  this.listContainer.css("max-height", "").css("overflow-y", "");
};
