Webr.component.Sortable = function (list, doNotSendIdsList) {
  var self = this;
  this.list = $(list);
  this.input = this.list.children().first().get(0);
  this.list.data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE, this);
  this.list.sortable({axis: "y"});
  this.list.disableSelection();
  if (!doNotSendIdsList) {
    // initial populate
    this.pupulateIntput();
  }

  this.list.bind("sortbeforestop", function (event, ui) {
    var ctx = ui["item"]["context"];
    var array = self.list.sortable("toArray");
    var index = jQuery.inArray(ctx.id, array) - 1;
    var leading = index == 0 ?null :$(document.getElementById(array[index])).attr("p0");
    self.onrowreposition($(document.getElementById(ctx.id)).attr("p0"), leading);
  });
  //handle order change
  this.list.bind("sortupdate", function (event, ui) {
    if (!doNotSendIdsList) {
      self.pupulateIntput();
    }

    self.onneworder();
  });
};
Webr.component.Sortable.prototype.toCommaIdString = function (elementsIdArray) {
  return jQuery.map(elementsIdArray, function (id) {
    return $(document.getElementById(id)).attr("p0");
  }).join(",");
};
Webr.component.Sortable.prototype.pupulateIntput = function () {
  this.input.value = this.toCommaIdString(this.list.sortable("toArray"));
};
Webr.component.Sortable.prototype.onneworder = function () {
  this.list.trigger("neworder");
};
Webr.component.Sortable.prototype.onrowreposition = function (moved, leading) {
  this.list.trigger("rowreposition", {moved: moved, leading: leading});
};
Webr.component.Sortable.registerSortable = function (path, comboboxSuffixName, doNotSendIdsList) {
  cr.forEach(path, comboboxSuffixName, function () {
    new Webr.component.Sortable(this, doNotSendIdsList);
  });
};
var regsort = Webr.component.Sortable.registerSortable;
