Webr.rest = {};
Webr.rest.Client = function (baseUrl, defaultAjaxSettings) {
  this.baseUrl = baseUrl;
  this.defautAjaxSettings = defaultAjaxSettings;
};
Webr.rest.Client.prototype.resource = function (config) {
  var resource = new Webr.rest.RootResource(this, config);
  return resource;
};
Webr.rest.Entity = function () {
};
Webr.rest.Entity.json = function (entity) {
  return {t: "application/json", v: jQuery.toJSON(entity)};
};
Webr.rest.PreventDoubleSubmit = function () {
};
Webr.rest.InProgress = function () {
  this.requestsInProgress = [];
};
Webr.rest.InProgress.prototype.checkDoubleSubmit = function (doubleSubmit, methodUrl) {
  var result = true;
  if (doubleSubmit && !doubleSubmit.recentOnly) {
    var requestId = (doubleSubmit.requestId || methodUrl);
    var requestInProgress = this.requestsInProgress[requestId];
    if (requestInProgress != null) {
      result = false;
    }

  }

  return result;
};
Webr.rest.InProgress.prototype.rememberEvent = function (event, doubleSubmit, methodUrl) {
  if (doubleSubmit) {
    var requestId = (doubleSubmit.requestId || methodUrl);
    if (doubleSubmit.recentOnly) {
      var previousEvent = this.requestsInProgress[requestId];
      if (previousEvent != null) {
        //Duck typing XHRDeferred / FileUploaded have abort()
        previousEvent.abort();
      }

    }

    this.requestsInProgress[requestId] = event;
    event.inProgressRequestId = requestId;
    //Duck typing XHRDeferred / FileUploaded have complete()
    event.complete(Webr.rest.InProgress.onComplete);
  }

};
Webr.rest.InProgress.prototype.isInFlight = function () {
  var count = 0;
  var requests = this.requestsInProgress;
  for ( var e in requests) {
    ++count;
  }

  return count > 0;
};
Webr.rest.InProgress.WEBR_AJAX_LISTENER = "_WEBR_REST_LISTENER_";
Webr.rest.InProgress.get = function () {
  if (Webr.rest.InProgress.instance == null) {
    Webr.rest.InProgress.instance = new Webr.rest.InProgress();
    //Support for selenium testing ajax request
    window[Webr.rest.InProgress.WEBR_AJAX_LISTENER] = Webr.rest.InProgress.instance;
  }

  return Webr.rest.InProgress.instance;
};
Webr.rest.InProgress.onComplete = function (event) {
  var requestId = event.inProgressRequestId;
  if (Webr.rest.InProgress.get().requestsInProgress[requestId] != null) {
    delete Webr.rest.InProgress.get().requestsInProgress[requestId];
  }

};
Webr.rest.RestConfig = function () {
};
Webr.rest.Resource = function (config) {
  this.config = config;
};
Webr.rest.Resource.prototype.subresource = function (config) {
  var subresource = new Webr.rest.Subresource(this, config);
  return subresource;
};
Webr.rest.Resource.prototype.method = function (methodType, config) {
  var method = new Webr.rest.Method(this, methodType, config);
  return method;
};
Webr.rest.Resource.prototype.getClient = function () {
};
Webr.rest.Resource.prototype.collectConfigs = function (configs) {
};
Webr.rest.RootResource = function (client, config) {
  Webr.rest.RootResource.superclass.constructor.call(this, config);
  this.client = client;
};
{
  var F = new Function();
  F.prototype = Webr.rest.Resource.prototype;
  Webr.rest.RootResource.prototype = new F();
  Webr.rest.RootResource.prototype.constructor = Webr.rest.RootResource;
  Webr.rest.RootResource.superclass = Webr.rest.Resource.prototype;
}

Webr.rest.RootResource.prototype.getClient = function () {
  return this.client;
};
Webr.rest.RootResource.prototype.collectConfigs = function (configs) {
  if (this.client.defautAjaxSettings) {
    configs.push({x: this.client.defautAjaxSettings});
  }

  configs.push(this.config);
};
Webr.rest.Subresource = function (parentResource, config) {
  Webr.rest.Subresource.superclass.constructor.call(this, config);
  this.parentResource = parentResource;
};
{
  var F = new Function();
  F.prototype = Webr.rest.Resource.prototype;
  Webr.rest.Subresource.prototype = new F();
  Webr.rest.Subresource.prototype.constructor = Webr.rest.Subresource;
  Webr.rest.Subresource.superclass = Webr.rest.Resource.prototype;
}

Webr.rest.Subresource.prototype.getClient = function () {
  return this.parentResource.getClient();
};
Webr.rest.Subresource.prototype.collectConfigs = function (configs) {
  this.parentResource.collectConfigs(configs);
  configs.push(this.config);
};
Webr.rest.Method = function (resource, method, config) {
  this.resource = resource;
  this.method = method;
  this.methodConfig = config;
};
Webr.rest.Method.prototype.call = function (requestConfig) {
  var configs = this.collectConfigs(requestConfig);
    

  var urlBuilder = [];
  this.appendBaseUrl(urlBuilder);
  Webr.rest.Method.appendPath(urlBuilder, configs);
    

  var methodUrl = urlBuilder.join("");
  var doubleSubmit;
  for (var i = configs.length - 1; i >= 0; --i) {
    doubleSubmit = doubleSubmit || configs[i].d;
  }

    

  var result = Webr.rest.Method.EMPTY_DEFERRED;
  if (Webr.rest.InProgress.get().checkDoubleSubmit(doubleSubmit, methodUrl)) {
    var fileInput = Webr.rest.Method.mergeConfigProperty(configs, "f");
        

    if (!fileInput) {
      Webr.rest.Method.appendQueryParameters(urlBuilder, configs);
            

      var entity = (requestConfig.e || this.methodConfig.e);
      var contentType = (entity && entity.t);
      var entityValue = (entity && entity.v);
            

      var ajaxSettings = Webr.rest.Method.mergeConfigProperty(configs, "x", {url: urlBuilder.join(""), type: this.method, contentType: contentType, data: entityValue});
            

      result = jQuery.ajax(ajaxSettings);
            

      Webr.rest.InProgress.get().rememberEvent(result, doubleSubmit, methodUrl);
    } else {
      var uploadSettings = Webr.rest.Method.mergeConfigProperty(configs, "u", {url: urlBuilder.join(""), params: Webr.rest.Method.mergeConfigProperty(configs, "q")});
            

      //TODO: implement FileUploader as XHRDeferred
      result = Webr.rest.FileUploader.upload(fileInput, uploadSettings);
            

      Webr.rest.InProgress.get().rememberEvent(uploadSettings, doubleSubmit, methodUrl);
    }

  }

  return result;
};
Webr.rest.Method.prototype.getUrl = function () {
  var configs = this.collectConfigs();
    

  var urlBuilder = [];
  this.appendBaseUrl(urlBuilder);
  Webr.rest.Method.appendPath(urlBuilder, configs);
  Webr.rest.Method.appendQueryParameters(urlBuilder, configs);
  return urlBuilder.join("");
};
Webr.rest.Method.prototype.appendBaseUrl = function (builder) {
  builder.push(this.resource.getClient().baseUrl, "rest");
};
Webr.rest.Method.prototype.collectConfigs = function (requestConfig) {
  var configs = [];
  this.resource.collectConfigs(configs);
  configs.push(this.methodConfig);
  if (requestConfig) {
    configs.push(requestConfig);
  }

  return configs;
};
Webr.rest.Method.EMPTY_DEFERRED = {done: function () {
  return this;
}, error: function () {
  return this;
}, fail: function () {
  return this;
}, success: function () {
  return this;
}, then: function () {
  return this;
}};
Webr.rest.Method.appendPath = function (builder, configs) {
  var requestConfig = configs[configs.length - 1];
  var len = requestConfig.p ?requestConfig.p.length :0;
  for (var i = 0; i < len; ++i) {
    var pathItem = null;
    for (var j = configs.length - 1; j >= 0; --j) {
      pathItem = pathItem || (configs[j].p && configs[j].p[i]);
    }

    builder.push("/", encodeURIComponent(pathItem));
  }

};
Webr.rest.Method.appendQueryParameters = function (builder, configs) {
  var query = Webr.rest.Method.mergeConfigProperty(configs, "q");
  if (query) {
    var queryString = jQuery.param(query);
    builder.push("?", queryString);
  }

};
Webr.rest.Method.mergeConfigProperty = function (configs, propertyName, initialPropertyValue) {
  var result = initialPropertyValue;
  for (var i = 0; i < configs.length; ++i) {
    var propertyValue = configs[i][propertyName];
    if (propertyValue) {
      result = result || {};
      for ( var key in propertyValue) {
        if (propertyValue[key] != null) {
          result[key] = propertyValue[key];
        }

      }

    }

  }

  return result;
};
