/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.javascript.runtime.escape;

public class JsStringUtil {
    private static final String EMPTY_STRING = "";
    private static final String[] NON_LITERAL_CHARS = new String[128];

    protected JsStringUtil() {
    }

    public static String stringLiteral(Object object) {
        if (object == null) {
            return EMPTY_STRING;
        }
        String str = object.toString();
        int capacity = str.length();
        StringBuilder builder = null;
        for (int i = 0; i < capacity; ++i) {
            String literal;
            char c = str.charAt(i);
            String string = literal = c < NON_LITERAL_CHARS.length ? NON_LITERAL_CHARS[c] : null;
            if (literal != null) {
                if (builder == null) {
                    builder = new StringBuilder(capacity + 16);
                    builder.append(str.substring(0, i));
                }
                builder.append(literal);
                continue;
            }
            if (builder == null) continue;
            builder.append(c);
        }
        if (builder != null) {
            return builder.toString();
        }
        return str;
    }

    static {
        JsStringUtil.NON_LITERAL_CHARS[0] = " ";
        JsStringUtil.NON_LITERAL_CHARS[92] = "\\\\";
        JsStringUtil.NON_LITERAL_CHARS[34] = "\\\"";
        JsStringUtil.NON_LITERAL_CHARS[39] = "\\'";
        JsStringUtil.NON_LITERAL_CHARS[10] = "\\n";
        JsStringUtil.NON_LITERAL_CHARS[13] = "\\r";
        JsStringUtil.NON_LITERAL_CHARS[9] = "\\t";
        JsStringUtil.NON_LITERAL_CHARS[47] = "\\/";
    }
}

