/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.component;

import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.RedirectException;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import webr.framework.runtime.response.CommandResponseAction;
import webr.framework.runtime.response.CommandScriptor;
import webr.framework.runtime.response.JsCommandResponse;
import webr.framework.textBuilder.TBuilderContext;

public class BaseHtmlTemplate {
    public static JsCommandResponse eval(TemplateComponent component, final String script) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append(script);
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse historyBack(TemplateComponent component) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("window.history.back();");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse redirect(TemplateComponent component, final String location) {
        if (component == null) {
            return null;
        }
        if (!ResponseFactory.isXMLHttpRequest()) {
            throw new RedirectException(location);
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.Event.redirect(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)location));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse redirectBack(TemplateComponent component) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("window.history.back();");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse reloadWindow(TemplateComponent component) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.Event.reload();");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showErrorMessage(TemplateComponent component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.ERROR.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showErrorMessage(TemplateComponent component, final String message, final int duration) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.ERROR.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", ");
                builderContext.append(String.valueOf(duration));
                builderContext.append(");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showErrorMessageDefault(TemplateComponent component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.ERROR.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", 4000);");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showInfoMessage(TemplateComponent component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.SYSTEM.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showInfoMessage(TemplateComponent component, final String message, final int duration) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.SYSTEM.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", ");
                builderContext.append(String.valueOf(duration));
                builderContext.append(");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showInfoMessageDefault(TemplateComponent component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.SYSTEM.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", 3000);");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showSystemMessage(TemplateComponent component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.SYSTEM.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showSystemMessage(TemplateComponent component, final String message, final int duration) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.SYSTEM.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", ");
                builderContext.append(String.valueOf(duration));
                builderContext.append(");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showSystemMessageDefault(TemplateComponent component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.SYSTEM.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", 3000);");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showInlineSystemMessage(TemplateComponent component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.INLINE_SYSTEM.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showInlineSystemMessage(TemplateComponent component, final String message, final int duration) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.INLINE_SYSTEM.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", ");
                builderContext.append(String.valueOf(duration));
                builderContext.append(");");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse showInlineSystemMessageDefault(TemplateComponent component, final String message) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.event.PopupMessage.INLINE_SYSTEM.show(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)message));
                builderContext.append("\", 3000);");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }

    public static JsCommandResponse closeErrorsPopup(TemplateComponent component) {
        if (component == null) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"execute\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("Webr.ErrorMessage.closePopup();");
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false);
    }
}

