/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.log4j;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.xml.DOMConfigurator;

public class AppRepositorySelector
implements RepositorySelector {
    private static boolean READY = false;
    private static Object GUARD = LogManager.getRootLogger();
    private static Map<ClassLoader, LoggerRepository> REPOSITORIES = new HashMap<ClassLoader, LoggerRepository>();
    private static LoggerRepository DEFAULT_REPOSITORY;

    private AppRepositorySelector() {
    }

    public LoggerRepository getLoggerRepository() {
        return AppRepositorySelector.getCurrentLoggerRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ServletContext context, URL log4jURL) throws ServletException {
        if (!READY) {
            Object object = GUARD;
            synchronized (object) {
                if (!READY) {
                    DEFAULT_REPOSITORY = LogManager.getLoggerRepository();
                    AppRepositorySelector instance = new AppRepositorySelector();
                    LogManager.setRepositorySelector((RepositorySelector)instance, (Object)GUARD);
                    READY = true;
                }
            }
        }
        Hierarchy h = new Hierarchy((Logger)new RootLogger(Level.DEBUG));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        AppRepositorySelector.initLoggers(context, log4jURL, h);
        REPOSITORIES.put(loader, (LoggerRepository)h);
    }

    public static void removeCurrent() {
        LoggerRepository repository = REPOSITORIES.remove(Thread.currentThread().getContextClassLoader());
        if (repository != null) {
            repository.shutdown();
        }
    }

    private static void initLoggers(ServletContext context, URL log4jURL, Hierarchy h) throws ServletException {
        try {
            final Properties configProps = new Properties();
            Enumeration initParams = context.getAttributeNames();
            while (initParams.hasMoreElements()) {
                String name = (String)initParams.nextElement();
                configProps.put(name, context.getAttribute(name));
            }
            new DOMConfigurator(){

                protected String subst(String value) {
                    try {
                        return OptionConverter.substVars((String)value, (Properties)configProps);
                    }
                    catch (IllegalArgumentException e) {
                        LogLog.warn((String)"Could not perform custom variable substitution.", (Throwable)e);
                        return value;
                    }
                }
            }.doConfigure(log4jURL, (LoggerRepository)h);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static LoggerRepository getCurrentLoggerRepository() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        LoggerRepository repository = REPOSITORIES.get(loader);
        return repository == null ? DEFAULT_REPOSITORY : repository;
    }
}

