/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import jetbrains.mps.webr.runtime.converter.ConvertException;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.requestProcessor.WindowManager;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.PageNotFoundException;
import jetbrains.mps.webr.runtime.templateComponent.RedirectException;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.ResponseAction;

public class ActionControllerUtil {
    private static ResponseAction doEnterAction(ActionController actionController, String windowId) {
        ResponseAction responseAction;
        try {
            responseAction = actionController.enterAction();
        }
        catch (PageNotFoundException e) {
            responseAction = ResponseFactory.getInstance().getNotFoundResponse(e.getMessage());
            WindowManager.getWindowManager().replaceActionController(windowId, null);
        }
        catch (ConvertException e) {
            responseAction = ResponseFactory.getInstance().getBadRequest(e.getMessage());
            WindowManager.getWindowManager().replaceActionController(windowId, null);
        }
        catch (SecurityException e) {
            responseAction = ResponseFactory.getInstance().getForbiddenResponse(e.getMessage());
            WindowManager.getWindowManager().replaceActionController(windowId, null);
        }
        catch (RedirectException e) {
            responseAction = ResponseFactory.getInstance().getRedirectResponse(e.getUrl());
            WindowManager.getWindowManager().replaceActionController(windowId, null);
        }
        return responseAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseAction processRequest(ActionFactory actionFactory, String controllerName, String actionName) {
        ResponseAction responseAction;
        ActionController actionController;
        WindowManager windowManager = WindowManager.getWindowManager();
        String windowId = windowManager.getRequestWindowId();
        boolean isWindowIdGenerated = false;
        if (windowId == null) {
            windowId = windowManager.generateWindowId();
            isWindowIdGenerated = true;
        }
        if ((actionController = actionFactory.createAction(actionName, windowId)) != null && actionController.isStreamedOutput()) {
            BaseApplication.setStreamedOutput();
        }
        if (actionController != null) {
            ActionController oldController = windowManager.getActionController(windowId);
            if (actionController.isSame(oldController)) {
                actionController = oldController;
                responseAction = actionController.refreshAction();
            } else {
                if (!actionController.isConcurrentAction()) {
                    if (oldController == null) {
                        windowManager.setActionController(windowId, actionController);
                        responseAction = ActionControllerUtil.doEnterAction(actionController, windowId);
                    } else {
                        WindowManager windowManager2 = windowManager;
                        synchronized (windowManager2) {
                            windowManager.replaceActionController(windowId, actionController);
                            responseAction = ActionControllerUtil.doEnterAction(actionController, windowId);
                        }
                    }
                } else {
                    responseAction = ActionControllerUtil.doEnterAction(actionController, windowId);
                }
                if (isWindowIdGenerated && actionController.isConcurrentAction()) {
                    actionController.exitActionSafe();
                }
            }
        } else {
            responseAction = ResponseFactory.getInstance().getNotFoundResponse("Action [" + actionName + "] wasn't found in controller [" + controllerName + "]");
        }
        return responseAction;
    }
}

