/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import java.util.Map;
import jetbrains.mps.webr.runtime.requestProcessor.ActionControllerUtil;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactoryContainer;
import jetbrains.mps.webr.runtime.url.RequestUri;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;

public class ActionRequestProcessor
implements RequestProcessor {
    protected static Log log = LogFactory.getLog(ActionRequestProcessor.class);
    private Map<RequestProcessor, String> dependentRequestProcessors;

    @Override
    public boolean isApplicable(RequestUri requestUri) {
        String controller = requestUri.getElement(0);
        return ((ActionFactoryContainer)ServiceLocator.getBean((String)"actionFactoryContainer")).containsFactory(controller);
    }

    @Override
    public Map<RequestProcessor, String> getDependentRequestProcessors() {
        return this.dependentRequestProcessors;
    }

    public void setDependentRequestProcessors(Map<RequestProcessor, String> precedingRequestProcessors) {
        this.dependentRequestProcessors = precedingRequestProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAction processRequest(RequestUri requestUri) {
        try {
            String controllerName = requestUri.getElement(0);
            ActionFactory factory = ((ActionFactoryContainer)ServiceLocator.getBean((String)"actionFactoryContainer")).getFactory(controllerName);
            String actionName = requestUri.getElement(1);
            ResponseAction responseAction = ActionControllerUtil.processRequest(factory, controllerName, actionName);
            return responseAction;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace((Object)DnqUtils.getTransactionsDump());
            }
        }
    }
}

