/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.resource;

import java.io.IOException;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.UrlGetter;
import jetbrains.mps.webr.runtime.resource.Resource;
import jetbrains.mps.webr.runtime.resource.ResourceBundleId;
import jetbrains.mps.webr.runtime.uri.hash.DigestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceBundle {
    protected static Log log = LogFactory.getLog(ResourceBundle.class);
    private String path = null;
    private String mimeType = null;
    private Locale locale;
    private String filePrefix;
    private String fileExt;
    private Set<Resource> resources = new LinkedHashSet<Resource>();

    public ResourceBundle(ResourceBundleId id) {
        this(id.getMimeType(), id.getLocale(), id.getResourceDescriptor().filePrefix, id.getResourceDescriptor().fileExt, id.getResourcePaths());
    }

    public ResourceBundle(String mimeType, Locale locale, String filePrefix, String fileExt, Iterable<UrlGetter> resources) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create new resource budle [" + mimeType + "]"));
        }
        this.mimeType = mimeType;
        this.locale = locale;
        this.filePrefix = filePrefix;
        this.fileExt = fileExt;
        for (UrlGetter urlGetter : Sequence.fromIterable(resources)) {
            this.resources.add(new Resource(urlGetter));
        }
    }

    public void writeTo(Writer output) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Write to output resource bundle [" + this.getPath() + "]"));
            }
            for (Resource r : this.resources) {
                r.writeTo(output);
                output.write("\n");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("End writing to output resource bundle [" + this.getPath() + "]"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean update() {
        boolean reload = false;
        for (Resource r : this.resources) {
            reload = reload || r.update();
        }
        if (reload) {
            this.path = null;
        }
        return reload;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.filePrefix + "-" + this.calculateHash() + "." + this.fileExt;
        }
        return this.path;
    }

    private String calculateHash() {
        MessageDigest md = DigestUtil.getMessageDigest();
        md.update(this.locale.toString().getBytes());
        for (Resource r : this.resources) {
            md.update(r.getContent().getBytes());
        }
        return DigestUtil.getStringResult(md.digest(), 0);
    }
}

