/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.staticHtml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.servlet.ServletUtil;
import jetbrains.mps.webr.runtime.staticHtml.HtmlScanner;
import jetbrains.mps.webr.runtime.staticHtml.StaticFtlUtil;
import jetbrains.mps.webr.runtime.staticHtml.StaticHtmlUtil;
import jetbrains.mps.webr.runtime.staticHtml.StaticTemplate;
import jetbrains.mps.webr.runtime.url.RequestUri;
import org.apache.commons.io.IOUtils;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;

public class StaticHtmlRequestProcessor
implements RequestProcessor {
    private Map<RequestProcessor, String> dependentRequestProcessors;

    @Override
    public boolean isApplicable(RequestUri requestUri) {
        String controller = requestUri.getElement(0);
        boolean applicable = false;
        if (BaseApplication.getCentralManager().isUsingStaticHtml()) {
            String path = requestUri.getTail(0);
            File file = ServletUtil.getHtmlFile(path);
            applicable = file != null;
        }
        return applicable;
    }

    @Override
    public Map<RequestProcessor, String> getDependentRequestProcessors() {
        return this.dependentRequestProcessors;
    }

    public void setDependentRequestProcessors(Map<RequestProcessor, String> precedingRequestProcessors) {
        this.dependentRequestProcessors = precedingRequestProcessors;
    }

    @Override
    public ResponseAction processRequest(RequestUri requestUri) {
        final String path = requestUri.getTail(0);
        final File file = ServletUtil.getHtmlFile(path);
        ResponseAction responseAction = file != null ? (path.endsWith(".html") ? StaticHtmlRequestProcessor.getFtlResponse(path, file) : new ResponseAction(){

            @Override
            public void doAction(HttpServletResponse response) throws IOException {
                ServletContext servletContext = BaseApplication.getServletContext();
                response.setContentType(servletContext.getMimeType(path));
                IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)response.getOutputStream());
            }
        }) : ResponseFactory.getInstance().getNotFoundResponse("Resource [" + path + "] was not found");
        return responseAction;
    }

    private static ResponseAction getHtmlResponse(final String path, File file) {
        final Wrappers._T text = new Wrappers._T((Object)StaticHtmlUtil.getText(file));
        IMapSequence rootMap = MapSequence.fromMap(new HashMap());
        StaticTemplate template = HtmlScanner.scan((String)text.value, (Map<String, Object>)rootMap);
        text.value = StaticHtmlUtil.getDefaultLayoutText((String)text.value, (Map<String, Object>)rootMap);
        ResponseAction responseAction = new ResponseAction(){

            @Override
            public void doAction(HttpServletResponse response) throws IOException {
                ServletContext servletContext = BaseApplication.getServletContext();
                response.setContentType(servletContext.getMimeType(path));
                IOUtils.copy((Reader)new StringReader((String)text.value), (OutputStream)response.getOutputStream());
            }
        };
        return responseAction;
    }

    private static ResponseAction getFtlResponse(final String path, File file) {
        final String text = StaticFtlUtil.getText(path);
        ResponseAction responseAction = new ResponseAction(){

            @Override
            public void doAction(HttpServletResponse response) throws IOException {
                ServletContext servletContext = BaseApplication.getServletContext();
                response.setContentType(servletContext.getMimeType(path));
                IOUtils.copy((Reader)new StringReader(text), (OutputStream)response.getOutputStream());
            }
        };
        return responseAction;
    }
}

